/*
 * Decompiled with CFR 0.152.
 */
package com.azure.containers.containerregistry.implementation.authentication;

import com.azure.containers.containerregistry.implementation.authentication.ContainerRegistryTokenRequestContext;
import com.azure.containers.containerregistry.implementation.authentication.ContainerRegistryTokenService;
import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.BearerTokenAuthenticationPolicy;
import reactor.core.publisher.Mono;

public final class ContainerRegistryCredentialsPolicy
extends BearerTokenAuthenticationPolicy {
    public static final String WWW_AUTHENTICATE = "WWW-Authenticate";
    public static final String SCOPES_PARAMETER = "scope";
    public static final String SERVICE_PARAMETER = "service";
    private final ContainerRegistryTokenService acrCredential;

    public ContainerRegistryCredentialsPolicy(ContainerRegistryTokenService tokenService, String scope) {
        super((TokenCredential)tokenService, new String[]{scope});
        this.acrCredential = tokenService;
    }

    public Mono<Void> authorizeRequest(HttpPipelineCallContext context) {
        this.authorizeRequestSync(context);
        return Mono.empty();
    }

    public Mono<Boolean> authorizeRequestOnChallenge(HttpPipelineCallContext context, HttpResponse response) {
        String authHeader = response.getHeaderValue(WWW_AUTHENTICATE);
        if (response.getStatusCode() != 401 || authHeader == null) {
            return Mono.just((Object)false);
        }
        String scope = this.extractValue(authHeader, SCOPES_PARAMETER);
        String serviceName = this.extractValue(authHeader, SERVICE_PARAMETER);
        if (scope != null && serviceName != null) {
            return this.setAuthorizationHeader(context, new ContainerRegistryTokenRequestContext(serviceName, scope)).thenReturn((Object)true);
        }
        return Mono.just((Object)false);
    }

    public void authorizeRequestSync(HttpPipelineCallContext context) {
        String lastToken = this.acrCredential.getLastToken();
        if (lastToken != null) {
            context.getHttpRequest().getHeaders().set(HttpHeaderName.AUTHORIZATION, "Bearer " + lastToken);
        }
    }

    public boolean authorizeRequestOnChallengeSync(HttpPipelineCallContext context, HttpResponse response) {
        String authHeader = response.getHeaderValue(WWW_AUTHENTICATE);
        if (response.getStatusCode() != 401 || authHeader == null) {
            return false;
        }
        String scope = this.extractValue(authHeader, SCOPES_PARAMETER);
        String serviceName = this.extractValue(authHeader, SERVICE_PARAMETER);
        if (scope != null && serviceName != null) {
            this.setAuthorizationHeaderSync(context, new ContainerRegistryTokenRequestContext(serviceName, scope));
            return true;
        }
        return false;
    }

    private String extractValue(String authHeader, String key) {
        int end;
        int start = authHeader.indexOf(key);
        if (start < 0 || authHeader.length() - start < key.length() + 3) {
            return null;
        }
        if (authHeader.charAt(start += key.length()) == '=' && authHeader.charAt(start + 1) == '\"' && (end = authHeader.indexOf(34, start += 2)) > start) {
            return authHeader.substring(start, end);
        }
        return null;
    }
}

