/*
 * Decompiled with CFR 0.152.
 */
package com.azure.containers.containerregistry.implementation;

import com.azure.containers.containerregistry.implementation.AuthenticationsImpl;
import com.azure.containers.containerregistry.implementation.ContainerRegistriesImpl;
import com.azure.containers.containerregistry.implementation.ContainerRegistryBlobsImpl;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.CookiePolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;

public final class AzureContainerRegistryImpl {
    private final String url;
    private final String apiVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    private final ContainerRegistriesImpl containerRegistries;
    private final ContainerRegistryBlobsImpl containerRegistryBlobs;
    private final AuthenticationsImpl authentications;

    public String getUrl() {
        return this.url;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    public ContainerRegistriesImpl getContainerRegistries() {
        return this.containerRegistries;
    }

    public ContainerRegistryBlobsImpl getContainerRegistryBlobs() {
        return this.containerRegistryBlobs;
    }

    public AuthenticationsImpl getAuthentications() {
        return this.authentications;
    }

    public AzureContainerRegistryImpl(String url, String apiVersion) {
        this(new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new UserAgentPolicy(), new RetryPolicy(), new CookiePolicy()}).build(), JacksonAdapter.createDefaultSerializerAdapter(), url, apiVersion);
    }

    public AzureContainerRegistryImpl(HttpPipeline httpPipeline, String url, String apiVersion) {
        this(httpPipeline, JacksonAdapter.createDefaultSerializerAdapter(), url, apiVersion);
    }

    public AzureContainerRegistryImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, String url, String apiVersion) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.url = url;
        this.apiVersion = apiVersion;
        this.containerRegistries = new ContainerRegistriesImpl(this);
        this.containerRegistryBlobs = new ContainerRegistryBlobsImpl(this);
        this.authentications = new AuthenticationsImpl(this);
    }
}

