/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.compute.batch.models.InstanceViewStatus;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class VMExtensionInstanceView
implements JsonSerializable<VMExtensionInstanceView> {
    private String name;
    private List<InstanceViewStatus> statuses;
    private List<InstanceViewStatus> subStatuses;

    private VMExtensionInstanceView() {
    }

    public String getName() {
        return this.name;
    }

    public List<InstanceViewStatus> getStatuses() {
        return this.statuses;
    }

    public List<InstanceViewStatus> getSubStatuses() {
        return this.subStatuses;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeArrayField("statuses", this.statuses, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("subStatuses", this.subStatuses, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static VMExtensionInstanceView fromJson(JsonReader jsonReader) throws IOException {
        return (VMExtensionInstanceView)jsonReader.readObject(reader -> {
            VMExtensionInstanceView deserializedVMExtensionInstanceView = new VMExtensionInstanceView();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedVMExtensionInstanceView.name = reader.getString();
                    continue;
                }
                if ("statuses".equals(fieldName)) {
                    List statuses;
                    deserializedVMExtensionInstanceView.statuses = statuses = reader.readArray(reader1 -> InstanceViewStatus.fromJson(reader1));
                    continue;
                }
                if ("subStatuses".equals(fieldName)) {
                    List subStatuses;
                    deserializedVMExtensionInstanceView.subStatuses = subStatuses = reader.readArray(reader1 -> InstanceViewStatus.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVMExtensionInstanceView;
        });
    }
}

