/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class UploadBatchServiceLogsResult
implements JsonSerializable<UploadBatchServiceLogsResult> {
    private final String virtualDirectoryName;
    private final int numberOfFilesUploaded;

    private UploadBatchServiceLogsResult(String virtualDirectoryName, int numberOfFilesUploaded) {
        this.virtualDirectoryName = virtualDirectoryName;
        this.numberOfFilesUploaded = numberOfFilesUploaded;
    }

    public String getVirtualDirectoryName() {
        return this.virtualDirectoryName;
    }

    public int getNumberOfFilesUploaded() {
        return this.numberOfFilesUploaded;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("virtualDirectoryName", this.virtualDirectoryName);
        jsonWriter.writeIntField("numberOfFilesUploaded", this.numberOfFilesUploaded);
        return jsonWriter.writeEndObject();
    }

    public static UploadBatchServiceLogsResult fromJson(JsonReader jsonReader) throws IOException {
        return (UploadBatchServiceLogsResult)jsonReader.readObject(reader -> {
            String virtualDirectoryName = null;
            int numberOfFilesUploaded = 0;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("virtualDirectoryName".equals(fieldName)) {
                    virtualDirectoryName = reader.getString();
                    continue;
                }
                if ("numberOfFilesUploaded".equals(fieldName)) {
                    numberOfFilesUploaded = reader.getInt();
                    continue;
                }
                reader.skipChildren();
            }
            return new UploadBatchServiceLogsResult(virtualDirectoryName, numberOfFilesUploaded);
        });
    }
}

