/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.compute.batch.models.AutomaticOsUpgradePolicy;
import com.azure.compute.batch.models.RollingUpgradePolicy;
import com.azure.compute.batch.models.UpgradeMode;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class UpgradePolicy
implements JsonSerializable<UpgradePolicy> {
    private final UpgradeMode mode;
    private AutomaticOsUpgradePolicy automaticOsUpgradePolicy;
    private RollingUpgradePolicy rollingUpgradePolicy;

    public UpgradePolicy(UpgradeMode mode) {
        this.mode = mode;
    }

    public UpgradeMode getMode() {
        return this.mode;
    }

    public AutomaticOsUpgradePolicy getAutomaticOsUpgradePolicy() {
        return this.automaticOsUpgradePolicy;
    }

    public UpgradePolicy setAutomaticOsUpgradePolicy(AutomaticOsUpgradePolicy automaticOsUpgradePolicy) {
        this.automaticOsUpgradePolicy = automaticOsUpgradePolicy;
        return this;
    }

    public RollingUpgradePolicy getRollingUpgradePolicy() {
        return this.rollingUpgradePolicy;
    }

    public UpgradePolicy setRollingUpgradePolicy(RollingUpgradePolicy rollingUpgradePolicy) {
        this.rollingUpgradePolicy = rollingUpgradePolicy;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("mode", this.mode == null ? null : this.mode.toString());
        jsonWriter.writeJsonField("automaticOSUpgradePolicy", (JsonSerializable)this.automaticOsUpgradePolicy);
        jsonWriter.writeJsonField("rollingUpgradePolicy", (JsonSerializable)this.rollingUpgradePolicy);
        return jsonWriter.writeEndObject();
    }

    public static UpgradePolicy fromJson(JsonReader jsonReader) throws IOException {
        return (UpgradePolicy)jsonReader.readObject(reader -> {
            UpgradeMode mode = null;
            AutomaticOsUpgradePolicy automaticOsUpgradePolicy = null;
            RollingUpgradePolicy rollingUpgradePolicy = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("mode".equals(fieldName)) {
                    mode = UpgradeMode.fromString(reader.getString());
                    continue;
                }
                if ("automaticOSUpgradePolicy".equals(fieldName)) {
                    automaticOsUpgradePolicy = AutomaticOsUpgradePolicy.fromJson(reader);
                    continue;
                }
                if ("rollingUpgradePolicy".equals(fieldName)) {
                    rollingUpgradePolicy = RollingUpgradePolicy.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            UpgradePolicy deserializedUpgradePolicy = new UpgradePolicy(mode);
            deserializedUpgradePolicy.automaticOsUpgradePolicy = automaticOsUpgradePolicy;
            deserializedUpgradePolicy.rollingUpgradePolicy = rollingUpgradePolicy;
            return deserializedUpgradePolicy;
        });
    }
}

