/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.compute.batch.models.OutputFileDestination;
import com.azure.compute.batch.models.OutputFileUploadConfig;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class OutputFile
implements JsonSerializable<OutputFile> {
    private final String filePattern;
    private final OutputFileDestination destination;
    private final OutputFileUploadConfig uploadOptions;

    public OutputFile(String filePattern, OutputFileDestination destination, OutputFileUploadConfig uploadOptions) {
        this.filePattern = filePattern;
        this.destination = destination;
        this.uploadOptions = uploadOptions;
    }

    public String getFilePattern() {
        return this.filePattern;
    }

    public OutputFileDestination getDestination() {
        return this.destination;
    }

    public OutputFileUploadConfig getUploadOptions() {
        return this.uploadOptions;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("filePattern", this.filePattern);
        jsonWriter.writeJsonField("destination", (JsonSerializable)this.destination);
        jsonWriter.writeJsonField("uploadOptions", (JsonSerializable)this.uploadOptions);
        return jsonWriter.writeEndObject();
    }

    public static OutputFile fromJson(JsonReader jsonReader) throws IOException {
        return (OutputFile)jsonReader.readObject(reader -> {
            String filePattern = null;
            OutputFileDestination destination = null;
            OutputFileUploadConfig uploadOptions = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("filePattern".equals(fieldName)) {
                    filePattern = reader.getString();
                    continue;
                }
                if ("destination".equals(fieldName)) {
                    destination = OutputFileDestination.fromJson(reader);
                    continue;
                }
                if ("uploadOptions".equals(fieldName)) {
                    uploadOptions = OutputFileUploadConfig.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return new OutputFile(filePattern, destination, uploadOptions);
        });
    }
}

