/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.compute.batch.models.InboundEndpointProtocol;
import com.azure.compute.batch.models.NetworkSecurityGroupRule;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class InboundNatPool
implements JsonSerializable<InboundNatPool> {
    private final String name;
    private final InboundEndpointProtocol protocol;
    private final int backendPort;
    private final int frontendPortRangeStart;
    private final int frontendPortRangeEnd;
    private List<NetworkSecurityGroupRule> networkSecurityGroupRules;

    public InboundNatPool(String name, InboundEndpointProtocol protocol, int backendPort, int frontendPortRangeStart, int frontendPortRangeEnd) {
        this.name = name;
        this.protocol = protocol;
        this.backendPort = backendPort;
        this.frontendPortRangeStart = frontendPortRangeStart;
        this.frontendPortRangeEnd = frontendPortRangeEnd;
    }

    public String getName() {
        return this.name;
    }

    public InboundEndpointProtocol getProtocol() {
        return this.protocol;
    }

    public int getBackendPort() {
        return this.backendPort;
    }

    public int getFrontendPortRangeStart() {
        return this.frontendPortRangeStart;
    }

    public int getFrontendPortRangeEnd() {
        return this.frontendPortRangeEnd;
    }

    public List<NetworkSecurityGroupRule> getNetworkSecurityGroupRules() {
        return this.networkSecurityGroupRules;
    }

    public InboundNatPool setNetworkSecurityGroupRules(List<NetworkSecurityGroupRule> networkSecurityGroupRules) {
        this.networkSecurityGroupRules = networkSecurityGroupRules;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("protocol", this.protocol == null ? null : this.protocol.toString());
        jsonWriter.writeIntField("backendPort", this.backendPort);
        jsonWriter.writeIntField("frontendPortRangeStart", this.frontendPortRangeStart);
        jsonWriter.writeIntField("frontendPortRangeEnd", this.frontendPortRangeEnd);
        jsonWriter.writeArrayField("networkSecurityGroupRules", this.networkSecurityGroupRules, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static InboundNatPool fromJson(JsonReader jsonReader) throws IOException {
        return (InboundNatPool)jsonReader.readObject(reader -> {
            String name = null;
            InboundEndpointProtocol protocol = null;
            int backendPort = 0;
            int frontendPortRangeStart = 0;
            int frontendPortRangeEnd = 0;
            List networkSecurityGroupRules = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    continue;
                }
                if ("protocol".equals(fieldName)) {
                    protocol = InboundEndpointProtocol.fromString(reader.getString());
                    continue;
                }
                if ("backendPort".equals(fieldName)) {
                    backendPort = reader.getInt();
                    continue;
                }
                if ("frontendPortRangeStart".equals(fieldName)) {
                    frontendPortRangeStart = reader.getInt();
                    continue;
                }
                if ("frontendPortRangeEnd".equals(fieldName)) {
                    frontendPortRangeEnd = reader.getInt();
                    continue;
                }
                if ("networkSecurityGroupRules".equals(fieldName)) {
                    networkSecurityGroupRules = reader.readArray(reader1 -> NetworkSecurityGroupRule.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            InboundNatPool deserializedInboundNatPool = new InboundNatPool(name, protocol, backendPort, frontendPortRangeStart, frontendPortRangeEnd);
            deserializedInboundNatPool.networkSecurityGroupRules = networkSecurityGroupRules;
            return deserializedInboundNatPool;
        });
    }
}

