/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.compute.batch.models.ExitOptions;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ExitCodeRangeMapping
implements JsonSerializable<ExitCodeRangeMapping> {
    private final int start;
    private final int end;
    private final ExitOptions exitOptions;

    public ExitCodeRangeMapping(int start, int end, ExitOptions exitOptions) {
        this.start = start;
        this.end = end;
        this.exitOptions = exitOptions;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public ExitOptions getExitOptions() {
        return this.exitOptions;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("start", this.start);
        jsonWriter.writeIntField("end", this.end);
        jsonWriter.writeJsonField("exitOptions", (JsonSerializable)this.exitOptions);
        return jsonWriter.writeEndObject();
    }

    public static ExitCodeRangeMapping fromJson(JsonReader jsonReader) throws IOException {
        return (ExitCodeRangeMapping)jsonReader.readObject(reader -> {
            int start = 0;
            int end = 0;
            ExitOptions exitOptions = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("start".equals(fieldName)) {
                    start = reader.getInt();
                    continue;
                }
                if ("end".equals(fieldName)) {
                    end = reader.getInt();
                    continue;
                }
                if ("exitOptions".equals(fieldName)) {
                    exitOptions = ExitOptions.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return new ExitCodeRangeMapping(start, end, exitOptions);
        });
    }
}

