/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.compute.batch.models.ExitOptions;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ExitCodeMapping
implements JsonSerializable<ExitCodeMapping> {
    private final int code;
    private final ExitOptions exitOptions;

    public ExitCodeMapping(int code, ExitOptions exitOptions) {
        this.code = code;
        this.exitOptions = exitOptions;
    }

    public int getCode() {
        return this.code;
    }

    public ExitOptions getExitOptions() {
        return this.exitOptions;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("code", this.code);
        jsonWriter.writeJsonField("exitOptions", (JsonSerializable)this.exitOptions);
        return jsonWriter.writeEndObject();
    }

    public static ExitCodeMapping fromJson(JsonReader jsonReader) throws IOException {
        return (ExitCodeMapping)jsonReader.readObject(reader -> {
            int code = 0;
            ExitOptions exitOptions = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("code".equals(fieldName)) {
                    code = reader.getInt();
                    continue;
                }
                if ("exitOptions".equals(fieldName)) {
                    exitOptions = ExitOptions.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return new ExitCodeMapping(code, exitOptions);
        });
    }
}

