/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.compute.batch.models.CachingType;
import com.azure.compute.batch.models.StorageAccountType;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class DataDisk
implements JsonSerializable<DataDisk> {
    private final int logicalUnitNumber;
    private CachingType caching;
    private final int diskSizeGb;
    private StorageAccountType storageAccountType;

    public DataDisk(int logicalUnitNumber, int diskSizeGb) {
        this.logicalUnitNumber = logicalUnitNumber;
        this.diskSizeGb = diskSizeGb;
    }

    public int getLogicalUnitNumber() {
        return this.logicalUnitNumber;
    }

    public CachingType getCaching() {
        return this.caching;
    }

    public DataDisk setCaching(CachingType caching) {
        this.caching = caching;
        return this;
    }

    public int getDiskSizeGb() {
        return this.diskSizeGb;
    }

    public StorageAccountType getStorageAccountType() {
        return this.storageAccountType;
    }

    public DataDisk setStorageAccountType(StorageAccountType storageAccountType) {
        this.storageAccountType = storageAccountType;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("lun", this.logicalUnitNumber);
        jsonWriter.writeIntField("diskSizeGB", this.diskSizeGb);
        jsonWriter.writeStringField("caching", this.caching == null ? null : this.caching.toString());
        jsonWriter.writeStringField("storageAccountType", this.storageAccountType == null ? null : this.storageAccountType.toString());
        return jsonWriter.writeEndObject();
    }

    public static DataDisk fromJson(JsonReader jsonReader) throws IOException {
        return (DataDisk)jsonReader.readObject(reader -> {
            int logicalUnitNumber = 0;
            int diskSizeGb = 0;
            CachingType caching = null;
            StorageAccountType storageAccountType = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("lun".equals(fieldName)) {
                    logicalUnitNumber = reader.getInt();
                    continue;
                }
                if ("diskSizeGB".equals(fieldName)) {
                    diskSizeGb = reader.getInt();
                    continue;
                }
                if ("caching".equals(fieldName)) {
                    caching = CachingType.fromString(reader.getString());
                    continue;
                }
                if ("storageAccountType".equals(fieldName)) {
                    storageAccountType = StorageAccountType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            DataDisk deserializedDataDisk = new DataDisk(logicalUnitNumber, diskSizeGb);
            deserializedDataDisk.caching = caching;
            deserializedDataDisk.storageAccountType = storageAccountType;
            return deserializedDataDisk;
        });
    }
}

