/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.compute.batch.models.BatchTaskExecutionInfo;
import com.azure.compute.batch.models.BatchTaskState;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class BatchTaskInfo
implements JsonSerializable<BatchTaskInfo> {
    private String taskUrl;
    private String jobId;
    private String taskId;
    private Integer subtaskId;
    private final BatchTaskState taskState;
    private BatchTaskExecutionInfo executionInfo;

    private BatchTaskInfo(BatchTaskState taskState) {
        this.taskState = taskState;
    }

    public String getTaskUrl() {
        return this.taskUrl;
    }

    public String getJobId() {
        return this.jobId;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public Integer getSubtaskId() {
        return this.subtaskId;
    }

    public BatchTaskState getTaskState() {
        return this.taskState;
    }

    public BatchTaskExecutionInfo getExecutionInfo() {
        return this.executionInfo;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("taskState", this.taskState == null ? null : this.taskState.toString());
        jsonWriter.writeStringField("taskUrl", this.taskUrl);
        jsonWriter.writeStringField("jobId", this.jobId);
        jsonWriter.writeStringField("taskId", this.taskId);
        jsonWriter.writeNumberField("subtaskId", (Number)this.subtaskId);
        jsonWriter.writeJsonField("executionInfo", (JsonSerializable)this.executionInfo);
        return jsonWriter.writeEndObject();
    }

    public static BatchTaskInfo fromJson(JsonReader jsonReader) throws IOException {
        return (BatchTaskInfo)jsonReader.readObject(reader -> {
            BatchTaskState taskState = null;
            String taskUrl = null;
            String jobId = null;
            String taskId = null;
            Integer subtaskId = null;
            BatchTaskExecutionInfo executionInfo = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("taskState".equals(fieldName)) {
                    taskState = BatchTaskState.fromString(reader.getString());
                    continue;
                }
                if ("taskUrl".equals(fieldName)) {
                    taskUrl = reader.getString();
                    continue;
                }
                if ("jobId".equals(fieldName)) {
                    jobId = reader.getString();
                    continue;
                }
                if ("taskId".equals(fieldName)) {
                    taskId = reader.getString();
                    continue;
                }
                if ("subtaskId".equals(fieldName)) {
                    subtaskId = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("executionInfo".equals(fieldName)) {
                    executionInfo = BatchTaskExecutionInfo.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            BatchTaskInfo deserializedBatchTaskInfo = new BatchTaskInfo(taskState);
            deserializedBatchTaskInfo.taskUrl = taskUrl;
            deserializedBatchTaskInfo.jobId = jobId;
            deserializedBatchTaskInfo.taskId = taskId;
            deserializedBatchTaskInfo.subtaskId = subtaskId;
            deserializedBatchTaskInfo.executionInfo = executionInfo;
            return deserializedBatchTaskInfo;
        });
    }
}

