/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.compute.batch.models.BatchTaskContainerExecutionInfo;
import com.azure.compute.batch.models.BatchTaskExecutionResult;
import com.azure.compute.batch.models.BatchTaskFailureInfo;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class BatchTaskExecutionInfo
implements JsonSerializable<BatchTaskExecutionInfo> {
    private OffsetDateTime startTime;
    private OffsetDateTime endTime;
    private Integer exitCode;
    private BatchTaskContainerExecutionInfo containerInfo;
    private BatchTaskFailureInfo failureInfo;
    private final int retryCount;
    private OffsetDateTime lastRetryTime;
    private final int requeueCount;
    private OffsetDateTime lastRequeueTime;
    private BatchTaskExecutionResult result;

    private BatchTaskExecutionInfo(int retryCount, int requeueCount) {
        this.retryCount = retryCount;
        this.requeueCount = requeueCount;
    }

    public OffsetDateTime getStartTime() {
        return this.startTime;
    }

    public OffsetDateTime getEndTime() {
        return this.endTime;
    }

    public Integer getExitCode() {
        return this.exitCode;
    }

    public BatchTaskContainerExecutionInfo getContainerInfo() {
        return this.containerInfo;
    }

    public BatchTaskFailureInfo getFailureInfo() {
        return this.failureInfo;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public OffsetDateTime getLastRetryTime() {
        return this.lastRetryTime;
    }

    public int getRequeueCount() {
        return this.requeueCount;
    }

    public OffsetDateTime getLastRequeueTime() {
        return this.lastRequeueTime;
    }

    public BatchTaskExecutionResult getResult() {
        return this.result;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("retryCount", this.retryCount);
        jsonWriter.writeIntField("requeueCount", this.requeueCount);
        jsonWriter.writeStringField("startTime", this.startTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startTime));
        jsonWriter.writeStringField("endTime", this.endTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endTime));
        jsonWriter.writeNumberField("exitCode", (Number)this.exitCode);
        jsonWriter.writeJsonField("containerInfo", (JsonSerializable)this.containerInfo);
        jsonWriter.writeJsonField("failureInfo", (JsonSerializable)this.failureInfo);
        jsonWriter.writeStringField("lastRetryTime", this.lastRetryTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastRetryTime));
        jsonWriter.writeStringField("lastRequeueTime", this.lastRequeueTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastRequeueTime));
        jsonWriter.writeStringField("result", this.result == null ? null : this.result.toString());
        return jsonWriter.writeEndObject();
    }

    public static BatchTaskExecutionInfo fromJson(JsonReader jsonReader) throws IOException {
        return (BatchTaskExecutionInfo)jsonReader.readObject(reader -> {
            int retryCount = 0;
            int requeueCount = 0;
            OffsetDateTime startTime = null;
            OffsetDateTime endTime = null;
            Integer exitCode = null;
            BatchTaskContainerExecutionInfo containerInfo = null;
            BatchTaskFailureInfo failureInfo = null;
            OffsetDateTime lastRetryTime = null;
            OffsetDateTime lastRequeueTime = null;
            BatchTaskExecutionResult result = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("retryCount".equals(fieldName)) {
                    retryCount = reader.getInt();
                    continue;
                }
                if ("requeueCount".equals(fieldName)) {
                    requeueCount = reader.getInt();
                    continue;
                }
                if ("startTime".equals(fieldName)) {
                    startTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("endTime".equals(fieldName)) {
                    endTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("exitCode".equals(fieldName)) {
                    exitCode = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("containerInfo".equals(fieldName)) {
                    containerInfo = BatchTaskContainerExecutionInfo.fromJson(reader);
                    continue;
                }
                if ("failureInfo".equals(fieldName)) {
                    failureInfo = BatchTaskFailureInfo.fromJson(reader);
                    continue;
                }
                if ("lastRetryTime".equals(fieldName)) {
                    lastRetryTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastRequeueTime".equals(fieldName)) {
                    lastRequeueTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("result".equals(fieldName)) {
                    result = BatchTaskExecutionResult.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            BatchTaskExecutionInfo deserializedBatchTaskExecutionInfo = new BatchTaskExecutionInfo(retryCount, requeueCount);
            deserializedBatchTaskExecutionInfo.startTime = startTime;
            deserializedBatchTaskExecutionInfo.endTime = endTime;
            deserializedBatchTaskExecutionInfo.exitCode = exitCode;
            deserializedBatchTaskExecutionInfo.containerInfo = containerInfo;
            deserializedBatchTaskExecutionInfo.failureInfo = failureInfo;
            deserializedBatchTaskExecutionInfo.lastRetryTime = lastRetryTime;
            deserializedBatchTaskExecutionInfo.lastRequeueTime = lastRequeueTime;
            deserializedBatchTaskExecutionInfo.result = result;
            return deserializedBatchTaskExecutionInfo;
        });
    }
}

