/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.compute.batch.models.BatchTaskIdRange;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class BatchTaskDependencies
implements JsonSerializable<BatchTaskDependencies> {
    private List<String> taskIds;
    private List<BatchTaskIdRange> taskIdRanges;

    public List<String> getTaskIds() {
        return this.taskIds;
    }

    public BatchTaskDependencies setTaskIds(List<String> taskIds) {
        this.taskIds = taskIds;
        return this;
    }

    public List<BatchTaskIdRange> getTaskIdRanges() {
        return this.taskIdRanges;
    }

    public BatchTaskDependencies setTaskIdRanges(List<BatchTaskIdRange> taskIdRanges) {
        this.taskIdRanges = taskIdRanges;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("taskIds", this.taskIds, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("taskIdRanges", this.taskIdRanges, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static BatchTaskDependencies fromJson(JsonReader jsonReader) throws IOException {
        return (BatchTaskDependencies)jsonReader.readObject(reader -> {
            BatchTaskDependencies deserializedBatchTaskDependencies = new BatchTaskDependencies();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("taskIds".equals(fieldName)) {
                    List taskIds;
                    deserializedBatchTaskDependencies.taskIds = taskIds = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("taskIdRanges".equals(fieldName)) {
                    List taskIdRanges;
                    deserializedBatchTaskDependencies.taskIdRanges = taskIdRanges = reader.readArray(reader1 -> BatchTaskIdRange.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBatchTaskDependencies;
        });
    }
}

