/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.compute.batch.models.BatchPoolResourceStatistics;
import com.azure.compute.batch.models.BatchPoolUsageStatistics;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class BatchPoolStatistics
implements JsonSerializable<BatchPoolStatistics> {
    private final String url;
    private final OffsetDateTime startTime;
    private final OffsetDateTime lastUpdateTime;
    private BatchPoolUsageStatistics usageStats;
    private BatchPoolResourceStatistics resourceStats;

    private BatchPoolStatistics(String url, OffsetDateTime startTime, OffsetDateTime lastUpdateTime) {
        this.url = url;
        this.startTime = startTime;
        this.lastUpdateTime = lastUpdateTime;
    }

    public String getUrl() {
        return this.url;
    }

    public OffsetDateTime getStartTime() {
        return this.startTime;
    }

    public OffsetDateTime getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public BatchPoolUsageStatistics getUsageStats() {
        return this.usageStats;
    }

    public BatchPoolResourceStatistics getResourceStats() {
        return this.resourceStats;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("url", this.url);
        jsonWriter.writeStringField("startTime", this.startTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startTime));
        jsonWriter.writeStringField("lastUpdateTime", this.lastUpdateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastUpdateTime));
        jsonWriter.writeJsonField("usageStats", (JsonSerializable)this.usageStats);
        jsonWriter.writeJsonField("resourceStats", (JsonSerializable)this.resourceStats);
        return jsonWriter.writeEndObject();
    }

    public static BatchPoolStatistics fromJson(JsonReader jsonReader) throws IOException {
        return (BatchPoolStatistics)jsonReader.readObject(reader -> {
            String url = null;
            OffsetDateTime startTime = null;
            OffsetDateTime lastUpdateTime = null;
            BatchPoolUsageStatistics usageStats = null;
            BatchPoolResourceStatistics resourceStats = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("url".equals(fieldName)) {
                    url = reader.getString();
                    continue;
                }
                if ("startTime".equals(fieldName)) {
                    startTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastUpdateTime".equals(fieldName)) {
                    lastUpdateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("usageStats".equals(fieldName)) {
                    usageStats = BatchPoolUsageStatistics.fromJson(reader);
                    continue;
                }
                if ("resourceStats".equals(fieldName)) {
                    resourceStats = BatchPoolResourceStatistics.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            BatchPoolStatistics deserializedBatchPoolStatistics = new BatchPoolStatistics(url, startTime, lastUpdateTime);
            deserializedBatchPoolStatistics.usageStats = usageStats;
            deserializedBatchPoolStatistics.resourceStats = resourceStats;
            return deserializedBatchPoolStatistics;
        });
    }
}

