/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.compute.batch.models.BatchAutoPoolSpecification;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class BatchPoolInfo
implements JsonSerializable<BatchPoolInfo> {
    private String poolId;
    private BatchAutoPoolSpecification autoPoolSpecification;

    public String getPoolId() {
        return this.poolId;
    }

    public BatchPoolInfo setPoolId(String poolId) {
        this.poolId = poolId;
        return this;
    }

    public BatchAutoPoolSpecification getAutoPoolSpecification() {
        return this.autoPoolSpecification;
    }

    public BatchPoolInfo setAutoPoolSpecification(BatchAutoPoolSpecification autoPoolSpecification) {
        this.autoPoolSpecification = autoPoolSpecification;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("poolId", this.poolId);
        jsonWriter.writeJsonField("autoPoolSpecification", (JsonSerializable)this.autoPoolSpecification);
        return jsonWriter.writeEndObject();
    }

    public static BatchPoolInfo fromJson(JsonReader jsonReader) throws IOException {
        return (BatchPoolInfo)jsonReader.readObject(reader -> {
            BatchPoolInfo deserializedBatchPoolInfo = new BatchPoolInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("poolId".equals(fieldName)) {
                    deserializedBatchPoolInfo.poolId = reader.getString();
                    continue;
                }
                if ("autoPoolSpecification".equals(fieldName)) {
                    deserializedBatchPoolInfo.autoPoolSpecification = BatchAutoPoolSpecification.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBatchPoolInfo;
        });
    }
}

