/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.compute.batch.models.BatchPoolIdentityType;
import com.azure.compute.batch.models.UserAssignedIdentity;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class BatchPoolIdentity
implements JsonSerializable<BatchPoolIdentity> {
    private final BatchPoolIdentityType type;
    private List<UserAssignedIdentity> userAssignedIdentities;

    private BatchPoolIdentity(BatchPoolIdentityType type) {
        this.type = type;
    }

    public BatchPoolIdentityType getType() {
        return this.type;
    }

    public List<UserAssignedIdentity> getUserAssignedIdentities() {
        return this.userAssignedIdentities;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeArrayField("userAssignedIdentities", this.userAssignedIdentities, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static BatchPoolIdentity fromJson(JsonReader jsonReader) throws IOException {
        return (BatchPoolIdentity)jsonReader.readObject(reader -> {
            BatchPoolIdentityType type = null;
            List userAssignedIdentities = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    type = BatchPoolIdentityType.fromString(reader.getString());
                    continue;
                }
                if ("userAssignedIdentities".equals(fieldName)) {
                    userAssignedIdentities = reader.readArray(reader1 -> UserAssignedIdentity.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            BatchPoolIdentity deserializedBatchPoolIdentity = new BatchPoolIdentity(type);
            deserializedBatchPoolIdentity.userAssignedIdentities = userAssignedIdentities;
            return deserializedBatchPoolIdentity;
        });
    }
}

