/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.compute.batch.models.BatchJobConstraints;
import com.azure.compute.batch.models.BatchJobNetworkConfiguration;
import com.azure.compute.batch.models.BatchPoolInfo;
import com.azure.compute.batch.models.MetadataItem;
import com.azure.compute.batch.models.OnAllBatchTasksComplete;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class BatchJobUpdateContent
implements JsonSerializable<BatchJobUpdateContent> {
    private Integer priority;
    private Boolean allowTaskPreemption;
    private Integer maxParallelTasks;
    private BatchJobConstraints constraints;
    private BatchPoolInfo poolInfo;
    private OnAllBatchTasksComplete onAllTasksComplete;
    private List<MetadataItem> metadata;
    private BatchJobNetworkConfiguration networkConfiguration;

    public Integer getPriority() {
        return this.priority;
    }

    public BatchJobUpdateContent setPriority(Integer priority) {
        this.priority = priority;
        return this;
    }

    public Boolean isAllowTaskPreemption() {
        return this.allowTaskPreemption;
    }

    public BatchJobUpdateContent setAllowTaskPreemption(Boolean allowTaskPreemption) {
        this.allowTaskPreemption = allowTaskPreemption;
        return this;
    }

    public Integer getMaxParallelTasks() {
        return this.maxParallelTasks;
    }

    public BatchJobUpdateContent setMaxParallelTasks(Integer maxParallelTasks) {
        this.maxParallelTasks = maxParallelTasks;
        return this;
    }

    public BatchJobConstraints getConstraints() {
        return this.constraints;
    }

    public BatchJobUpdateContent setConstraints(BatchJobConstraints constraints) {
        this.constraints = constraints;
        return this;
    }

    public BatchPoolInfo getPoolInfo() {
        return this.poolInfo;
    }

    public BatchJobUpdateContent setPoolInfo(BatchPoolInfo poolInfo) {
        this.poolInfo = poolInfo;
        return this;
    }

    public OnAllBatchTasksComplete getOnAllTasksComplete() {
        return this.onAllTasksComplete;
    }

    public BatchJobUpdateContent setOnAllTasksComplete(OnAllBatchTasksComplete onAllTasksComplete) {
        this.onAllTasksComplete = onAllTasksComplete;
        return this;
    }

    public List<MetadataItem> getMetadata() {
        return this.metadata;
    }

    public BatchJobUpdateContent setMetadata(List<MetadataItem> metadata) {
        this.metadata = metadata;
        return this;
    }

    public BatchJobNetworkConfiguration getNetworkConfiguration() {
        return this.networkConfiguration;
    }

    public BatchJobUpdateContent setNetworkConfiguration(BatchJobNetworkConfiguration networkConfiguration) {
        this.networkConfiguration = networkConfiguration;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("priority", (Number)this.priority);
        jsonWriter.writeBooleanField("allowTaskPreemption", this.allowTaskPreemption);
        jsonWriter.writeNumberField("maxParallelTasks", (Number)this.maxParallelTasks);
        jsonWriter.writeJsonField("constraints", (JsonSerializable)this.constraints);
        jsonWriter.writeJsonField("poolInfo", (JsonSerializable)this.poolInfo);
        jsonWriter.writeStringField("onAllTasksComplete", this.onAllTasksComplete == null ? null : this.onAllTasksComplete.toString());
        jsonWriter.writeArrayField("metadata", this.metadata, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("networkConfiguration", (JsonSerializable)this.networkConfiguration);
        return jsonWriter.writeEndObject();
    }

    public static BatchJobUpdateContent fromJson(JsonReader jsonReader) throws IOException {
        return (BatchJobUpdateContent)jsonReader.readObject(reader -> {
            BatchJobUpdateContent deserializedBatchJobUpdateContent = new BatchJobUpdateContent();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("priority".equals(fieldName)) {
                    deserializedBatchJobUpdateContent.priority = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("allowTaskPreemption".equals(fieldName)) {
                    deserializedBatchJobUpdateContent.allowTaskPreemption = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("maxParallelTasks".equals(fieldName)) {
                    deserializedBatchJobUpdateContent.maxParallelTasks = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("constraints".equals(fieldName)) {
                    deserializedBatchJobUpdateContent.constraints = BatchJobConstraints.fromJson(reader);
                    continue;
                }
                if ("poolInfo".equals(fieldName)) {
                    deserializedBatchJobUpdateContent.poolInfo = BatchPoolInfo.fromJson(reader);
                    continue;
                }
                if ("onAllTasksComplete".equals(fieldName)) {
                    deserializedBatchJobUpdateContent.onAllTasksComplete = OnAllBatchTasksComplete.fromString(reader.getString());
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    List metadata;
                    deserializedBatchJobUpdateContent.metadata = metadata = reader.readArray(reader1 -> MetadataItem.fromJson(reader1));
                    continue;
                }
                if ("networkConfiguration".equals(fieldName)) {
                    deserializedBatchJobUpdateContent.networkConfiguration = BatchJobNetworkConfiguration.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBatchJobUpdateContent;
        });
    }
}

