/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;

public final class BatchJobScheduleStatistics
implements JsonSerializable<BatchJobScheduleStatistics> {
    private final String url;
    private final OffsetDateTime startTime;
    private final OffsetDateTime lastUpdateTime;
    private final Duration userCpuTime;
    private final Duration kernelCpuTime;
    private final Duration wallClockTime;
    private final long readIOps;
    private final long writeIOps;
    private final double readIOGiB;
    private final double writeIOGiB;
    private final long numSucceededTasks;
    private final long numFailedTasks;
    private final long numTaskRetries;
    private final Duration waitTime;

    private BatchJobScheduleStatistics(String url, OffsetDateTime startTime, OffsetDateTime lastUpdateTime, Duration userCpuTime, Duration kernelCpuTime, Duration wallClockTime, long readIOps, long writeIOps, double readIOGiB, double writeIOGiB, long numSucceededTasks, long numFailedTasks, long numTaskRetries, Duration waitTime) {
        this.url = url;
        this.startTime = startTime;
        this.lastUpdateTime = lastUpdateTime;
        this.userCpuTime = userCpuTime;
        this.kernelCpuTime = kernelCpuTime;
        this.wallClockTime = wallClockTime;
        this.readIOps = readIOps;
        this.writeIOps = writeIOps;
        this.readIOGiB = readIOGiB;
        this.writeIOGiB = writeIOGiB;
        this.numSucceededTasks = numSucceededTasks;
        this.numFailedTasks = numFailedTasks;
        this.numTaskRetries = numTaskRetries;
        this.waitTime = waitTime;
    }

    public String getUrl() {
        return this.url;
    }

    public OffsetDateTime getStartTime() {
        return this.startTime;
    }

    public OffsetDateTime getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public Duration getUserCpuTime() {
        return this.userCpuTime;
    }

    public Duration getKernelCpuTime() {
        return this.kernelCpuTime;
    }

    public Duration getWallClockTime() {
        return this.wallClockTime;
    }

    public long getReadIOps() {
        return this.readIOps;
    }

    public long getWriteIOps() {
        return this.writeIOps;
    }

    public double getReadIOGiB() {
        return this.readIOGiB;
    }

    public double getWriteIOGiB() {
        return this.writeIOGiB;
    }

    public long getNumSucceededTasks() {
        return this.numSucceededTasks;
    }

    public long getNumFailedTasks() {
        return this.numFailedTasks;
    }

    public long getNumTaskRetries() {
        return this.numTaskRetries;
    }

    public Duration getWaitTime() {
        return this.waitTime;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("url", this.url);
        jsonWriter.writeStringField("startTime", this.startTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startTime));
        jsonWriter.writeStringField("lastUpdateTime", this.lastUpdateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastUpdateTime));
        jsonWriter.writeStringField("userCPUTime", CoreUtils.durationToStringWithDays((Duration)this.userCpuTime));
        jsonWriter.writeStringField("kernelCPUTime", CoreUtils.durationToStringWithDays((Duration)this.kernelCpuTime));
        jsonWriter.writeStringField("wallClockTime", CoreUtils.durationToStringWithDays((Duration)this.wallClockTime));
        jsonWriter.writeStringField("readIOps", Objects.toString(this.readIOps, null));
        jsonWriter.writeStringField("writeIOps", Objects.toString(this.writeIOps, null));
        jsonWriter.writeDoubleField("readIOGiB", this.readIOGiB);
        jsonWriter.writeDoubleField("writeIOGiB", this.writeIOGiB);
        jsonWriter.writeStringField("numSucceededTasks", Objects.toString(this.numSucceededTasks, null));
        jsonWriter.writeStringField("numFailedTasks", Objects.toString(this.numFailedTasks, null));
        jsonWriter.writeStringField("numTaskRetries", Objects.toString(this.numTaskRetries, null));
        jsonWriter.writeStringField("waitTime", CoreUtils.durationToStringWithDays((Duration)this.waitTime));
        return jsonWriter.writeEndObject();
    }

    public static BatchJobScheduleStatistics fromJson(JsonReader jsonReader) throws IOException {
        return (BatchJobScheduleStatistics)jsonReader.readObject(reader -> {
            String url = null;
            OffsetDateTime startTime = null;
            OffsetDateTime lastUpdateTime = null;
            Duration userCpuTime = null;
            Duration kernelCpuTime = null;
            Duration wallClockTime = null;
            long readIOps = Long.parseLong("0");
            long writeIOps = Long.parseLong("0");
            double readIOGiB = 0.0;
            double writeIOGiB = 0.0;
            long numSucceededTasks = Long.parseLong("0");
            long numFailedTasks = Long.parseLong("0");
            long numTaskRetries = Long.parseLong("0");
            Duration waitTime = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("url".equals(fieldName)) {
                    url = reader.getString();
                    continue;
                }
                if ("startTime".equals(fieldName)) {
                    startTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastUpdateTime".equals(fieldName)) {
                    lastUpdateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("userCPUTime".equals(fieldName)) {
                    userCpuTime = (Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                if ("kernelCPUTime".equals(fieldName)) {
                    kernelCpuTime = (Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                if ("wallClockTime".equals(fieldName)) {
                    wallClockTime = (Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                if ("readIOps".equals(fieldName)) {
                    readIOps = (Long)reader.getNullable(nonNullReader -> Long.parseLong(nonNullReader.getString()));
                    continue;
                }
                if ("writeIOps".equals(fieldName)) {
                    writeIOps = (Long)reader.getNullable(nonNullReader -> Long.parseLong(nonNullReader.getString()));
                    continue;
                }
                if ("readIOGiB".equals(fieldName)) {
                    readIOGiB = reader.getDouble();
                    continue;
                }
                if ("writeIOGiB".equals(fieldName)) {
                    writeIOGiB = reader.getDouble();
                    continue;
                }
                if ("numSucceededTasks".equals(fieldName)) {
                    numSucceededTasks = (Long)reader.getNullable(nonNullReader -> Long.parseLong(nonNullReader.getString()));
                    continue;
                }
                if ("numFailedTasks".equals(fieldName)) {
                    numFailedTasks = (Long)reader.getNullable(nonNullReader -> Long.parseLong(nonNullReader.getString()));
                    continue;
                }
                if ("numTaskRetries".equals(fieldName)) {
                    numTaskRetries = (Long)reader.getNullable(nonNullReader -> Long.parseLong(nonNullReader.getString()));
                    continue;
                }
                if ("waitTime".equals(fieldName)) {
                    waitTime = (Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return new BatchJobScheduleStatistics(url, startTime, lastUpdateTime, userCpuTime, kernelCpuTime, wallClockTime, readIOps, writeIOps, readIOGiB, writeIOGiB, numSucceededTasks, numFailedTasks, numTaskRetries, waitTime);
        });
    }
}

