/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.compute.batch.models.BatchTaskContainerSettings;
import com.azure.compute.batch.models.EnvironmentSetting;
import com.azure.compute.batch.models.ResourceFile;
import com.azure.compute.batch.models.UserIdentity;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Duration;
import java.util.List;

public final class BatchJobReleaseTask
implements JsonSerializable<BatchJobReleaseTask> {
    private String id;
    private final String commandLine;
    private BatchTaskContainerSettings containerSettings;
    private List<ResourceFile> resourceFiles;
    private List<EnvironmentSetting> environmentSettings;
    private Duration maxWallClockTime;
    private Duration retentionTime;
    private UserIdentity userIdentity;

    public BatchJobReleaseTask(String commandLine) {
        this.commandLine = commandLine;
    }

    public String getId() {
        return this.id;
    }

    public BatchJobReleaseTask setId(String id) {
        this.id = id;
        return this;
    }

    public String getCommandLine() {
        return this.commandLine;
    }

    public BatchTaskContainerSettings getContainerSettings() {
        return this.containerSettings;
    }

    public BatchJobReleaseTask setContainerSettings(BatchTaskContainerSettings containerSettings) {
        this.containerSettings = containerSettings;
        return this;
    }

    public List<ResourceFile> getResourceFiles() {
        return this.resourceFiles;
    }

    public BatchJobReleaseTask setResourceFiles(List<ResourceFile> resourceFiles) {
        this.resourceFiles = resourceFiles;
        return this;
    }

    public List<EnvironmentSetting> getEnvironmentSettings() {
        return this.environmentSettings;
    }

    public BatchJobReleaseTask setEnvironmentSettings(List<EnvironmentSetting> environmentSettings) {
        this.environmentSettings = environmentSettings;
        return this;
    }

    public Duration getMaxWallClockTime() {
        return this.maxWallClockTime;
    }

    public BatchJobReleaseTask setMaxWallClockTime(Duration maxWallClockTime) {
        this.maxWallClockTime = maxWallClockTime;
        return this;
    }

    public Duration getRetentionTime() {
        return this.retentionTime;
    }

    public BatchJobReleaseTask setRetentionTime(Duration retentionTime) {
        this.retentionTime = retentionTime;
        return this;
    }

    public UserIdentity getUserIdentity() {
        return this.userIdentity;
    }

    public BatchJobReleaseTask setUserIdentity(UserIdentity userIdentity) {
        this.userIdentity = userIdentity;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("commandLine", this.commandLine);
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeJsonField("containerSettings", (JsonSerializable)this.containerSettings);
        jsonWriter.writeArrayField("resourceFiles", this.resourceFiles, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("environmentSettings", this.environmentSettings, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("maxWallClockTime", CoreUtils.durationToStringWithDays((Duration)this.maxWallClockTime));
        jsonWriter.writeStringField("retentionTime", CoreUtils.durationToStringWithDays((Duration)this.retentionTime));
        jsonWriter.writeJsonField("userIdentity", (JsonSerializable)this.userIdentity);
        return jsonWriter.writeEndObject();
    }

    public static BatchJobReleaseTask fromJson(JsonReader jsonReader) throws IOException {
        return (BatchJobReleaseTask)jsonReader.readObject(reader -> {
            String commandLine = null;
            String id = null;
            BatchTaskContainerSettings containerSettings = null;
            List resourceFiles = null;
            List environmentSettings = null;
            Duration maxWallClockTime = null;
            Duration retentionTime = null;
            UserIdentity userIdentity = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("commandLine".equals(fieldName)) {
                    commandLine = reader.getString();
                    continue;
                }
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                    continue;
                }
                if ("containerSettings".equals(fieldName)) {
                    containerSettings = BatchTaskContainerSettings.fromJson(reader);
                    continue;
                }
                if ("resourceFiles".equals(fieldName)) {
                    resourceFiles = reader.readArray(reader1 -> ResourceFile.fromJson(reader1));
                    continue;
                }
                if ("environmentSettings".equals(fieldName)) {
                    environmentSettings = reader.readArray(reader1 -> EnvironmentSetting.fromJson(reader1));
                    continue;
                }
                if ("maxWallClockTime".equals(fieldName)) {
                    maxWallClockTime = (Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                if ("retentionTime".equals(fieldName)) {
                    retentionTime = (Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                if ("userIdentity".equals(fieldName)) {
                    userIdentity = UserIdentity.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            BatchJobReleaseTask deserializedBatchJobReleaseTask = new BatchJobReleaseTask(commandLine);
            deserializedBatchJobReleaseTask.id = id;
            deserializedBatchJobReleaseTask.containerSettings = containerSettings;
            deserializedBatchJobReleaseTask.resourceFiles = resourceFiles;
            deserializedBatchJobReleaseTask.environmentSettings = environmentSettings;
            deserializedBatchJobReleaseTask.maxWallClockTime = maxWallClockTime;
            deserializedBatchJobReleaseTask.retentionTime = retentionTime;
            deserializedBatchJobReleaseTask.userIdentity = userIdentity;
            return deserializedBatchJobReleaseTask;
        });
    }
}

