/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.compute.batch.models.BatchTaskConstraints;
import com.azure.compute.batch.models.BatchTaskContainerSettings;
import com.azure.compute.batch.models.EnvironmentSetting;
import com.azure.compute.batch.models.ResourceFile;
import com.azure.compute.batch.models.UserIdentity;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class BatchJobPreparationTask
implements JsonSerializable<BatchJobPreparationTask> {
    private String id;
    private final String commandLine;
    private BatchTaskContainerSettings containerSettings;
    private List<ResourceFile> resourceFiles;
    private List<EnvironmentSetting> environmentSettings;
    private BatchTaskConstraints constraints;
    private Boolean waitForSuccess;
    private UserIdentity userIdentity;
    private Boolean rerunOnNodeRebootAfterSuccess;

    public BatchJobPreparationTask(String commandLine) {
        this.commandLine = commandLine;
    }

    public String getId() {
        return this.id;
    }

    public BatchJobPreparationTask setId(String id) {
        this.id = id;
        return this;
    }

    public String getCommandLine() {
        return this.commandLine;
    }

    public BatchTaskContainerSettings getContainerSettings() {
        return this.containerSettings;
    }

    public BatchJobPreparationTask setContainerSettings(BatchTaskContainerSettings containerSettings) {
        this.containerSettings = containerSettings;
        return this;
    }

    public List<ResourceFile> getResourceFiles() {
        return this.resourceFiles;
    }

    public BatchJobPreparationTask setResourceFiles(List<ResourceFile> resourceFiles) {
        this.resourceFiles = resourceFiles;
        return this;
    }

    public List<EnvironmentSetting> getEnvironmentSettings() {
        return this.environmentSettings;
    }

    public BatchJobPreparationTask setEnvironmentSettings(List<EnvironmentSetting> environmentSettings) {
        this.environmentSettings = environmentSettings;
        return this;
    }

    public BatchTaskConstraints getConstraints() {
        return this.constraints;
    }

    public BatchJobPreparationTask setConstraints(BatchTaskConstraints constraints) {
        this.constraints = constraints;
        return this;
    }

    public Boolean isWaitForSuccess() {
        return this.waitForSuccess;
    }

    public BatchJobPreparationTask setWaitForSuccess(Boolean waitForSuccess) {
        this.waitForSuccess = waitForSuccess;
        return this;
    }

    public UserIdentity getUserIdentity() {
        return this.userIdentity;
    }

    public BatchJobPreparationTask setUserIdentity(UserIdentity userIdentity) {
        this.userIdentity = userIdentity;
        return this;
    }

    public Boolean isRerunOnNodeRebootAfterSuccess() {
        return this.rerunOnNodeRebootAfterSuccess;
    }

    public BatchJobPreparationTask setRerunOnNodeRebootAfterSuccess(Boolean rerunOnNodeRebootAfterSuccess) {
        this.rerunOnNodeRebootAfterSuccess = rerunOnNodeRebootAfterSuccess;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("commandLine", this.commandLine);
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeJsonField("containerSettings", (JsonSerializable)this.containerSettings);
        jsonWriter.writeArrayField("resourceFiles", this.resourceFiles, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("environmentSettings", this.environmentSettings, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("constraints", (JsonSerializable)this.constraints);
        jsonWriter.writeBooleanField("waitForSuccess", this.waitForSuccess);
        jsonWriter.writeJsonField("userIdentity", (JsonSerializable)this.userIdentity);
        jsonWriter.writeBooleanField("rerunOnNodeRebootAfterSuccess", this.rerunOnNodeRebootAfterSuccess);
        return jsonWriter.writeEndObject();
    }

    public static BatchJobPreparationTask fromJson(JsonReader jsonReader) throws IOException {
        return (BatchJobPreparationTask)jsonReader.readObject(reader -> {
            String commandLine = null;
            String id = null;
            BatchTaskContainerSettings containerSettings = null;
            List resourceFiles = null;
            List environmentSettings = null;
            BatchTaskConstraints constraints = null;
            Boolean waitForSuccess = null;
            UserIdentity userIdentity = null;
            Boolean rerunOnNodeRebootAfterSuccess = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("commandLine".equals(fieldName)) {
                    commandLine = reader.getString();
                    continue;
                }
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                    continue;
                }
                if ("containerSettings".equals(fieldName)) {
                    containerSettings = BatchTaskContainerSettings.fromJson(reader);
                    continue;
                }
                if ("resourceFiles".equals(fieldName)) {
                    resourceFiles = reader.readArray(reader1 -> ResourceFile.fromJson(reader1));
                    continue;
                }
                if ("environmentSettings".equals(fieldName)) {
                    environmentSettings = reader.readArray(reader1 -> EnvironmentSetting.fromJson(reader1));
                    continue;
                }
                if ("constraints".equals(fieldName)) {
                    constraints = BatchTaskConstraints.fromJson(reader);
                    continue;
                }
                if ("waitForSuccess".equals(fieldName)) {
                    waitForSuccess = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("userIdentity".equals(fieldName)) {
                    userIdentity = UserIdentity.fromJson(reader);
                    continue;
                }
                if ("rerunOnNodeRebootAfterSuccess".equals(fieldName)) {
                    rerunOnNodeRebootAfterSuccess = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            BatchJobPreparationTask deserializedBatchJobPreparationTask = new BatchJobPreparationTask(commandLine);
            deserializedBatchJobPreparationTask.id = id;
            deserializedBatchJobPreparationTask.containerSettings = containerSettings;
            deserializedBatchJobPreparationTask.resourceFiles = resourceFiles;
            deserializedBatchJobPreparationTask.environmentSettings = environmentSettings;
            deserializedBatchJobPreparationTask.constraints = constraints;
            deserializedBatchJobPreparationTask.waitForSuccess = waitForSuccess;
            deserializedBatchJobPreparationTask.userIdentity = userIdentity;
            deserializedBatchJobPreparationTask.rerunOnNodeRebootAfterSuccess = rerunOnNodeRebootAfterSuccess;
            return deserializedBatchJobPreparationTask;
        });
    }
}

