/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.compute.batch.models.BatchCertificateStoreLocation;
import com.azure.compute.batch.models.BatchCertificateVisibility;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class BatchCertificateReference
implements JsonSerializable<BatchCertificateReference> {
    private final String thumbprint;
    private final String thumbprintAlgorithm;
    private BatchCertificateStoreLocation storeLocation;
    private String storeName;
    private List<BatchCertificateVisibility> visibility;

    public BatchCertificateReference(String thumbprint, String thumbprintAlgorithm) {
        this.thumbprint = thumbprint;
        this.thumbprintAlgorithm = thumbprintAlgorithm;
    }

    public String getThumbprint() {
        return this.thumbprint;
    }

    public String getThumbprintAlgorithm() {
        return this.thumbprintAlgorithm;
    }

    public BatchCertificateStoreLocation getStoreLocation() {
        return this.storeLocation;
    }

    public BatchCertificateReference setStoreLocation(BatchCertificateStoreLocation storeLocation) {
        this.storeLocation = storeLocation;
        return this;
    }

    public String getStoreName() {
        return this.storeName;
    }

    public BatchCertificateReference setStoreName(String storeName) {
        this.storeName = storeName;
        return this;
    }

    public List<BatchCertificateVisibility> getVisibility() {
        return this.visibility;
    }

    public BatchCertificateReference setVisibility(List<BatchCertificateVisibility> visibility) {
        this.visibility = visibility;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("thumbprint", this.thumbprint);
        jsonWriter.writeStringField("thumbprintAlgorithm", this.thumbprintAlgorithm);
        jsonWriter.writeStringField("storeLocation", this.storeLocation == null ? null : this.storeLocation.toString());
        jsonWriter.writeStringField("storeName", this.storeName);
        jsonWriter.writeArrayField("visibility", this.visibility, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        return jsonWriter.writeEndObject();
    }

    public static BatchCertificateReference fromJson(JsonReader jsonReader) throws IOException {
        return (BatchCertificateReference)jsonReader.readObject(reader -> {
            String thumbprint = null;
            String thumbprintAlgorithm = null;
            BatchCertificateStoreLocation storeLocation = null;
            String storeName = null;
            List visibility = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("thumbprint".equals(fieldName)) {
                    thumbprint = reader.getString();
                    continue;
                }
                if ("thumbprintAlgorithm".equals(fieldName)) {
                    thumbprintAlgorithm = reader.getString();
                    continue;
                }
                if ("storeLocation".equals(fieldName)) {
                    storeLocation = BatchCertificateStoreLocation.fromString(reader.getString());
                    continue;
                }
                if ("storeName".equals(fieldName)) {
                    storeName = reader.getString();
                    continue;
                }
                if ("visibility".equals(fieldName)) {
                    visibility = reader.readArray(reader1 -> BatchCertificateVisibility.fromString(reader1.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            BatchCertificateReference deserializedBatchCertificateReference = new BatchCertificateReference(thumbprint, thumbprintAlgorithm);
            deserializedBatchCertificateReference.storeLocation = storeLocation;
            deserializedBatchCertificateReference.storeName = storeName;
            deserializedBatchCertificateReference.visibility = visibility;
            return deserializedBatchCertificateReference;
        });
    }
}

