/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class BatchApplicationPackageReference
implements JsonSerializable<BatchApplicationPackageReference> {
    private final String applicationId;
    private String version;

    public BatchApplicationPackageReference(String applicationId) {
        this.applicationId = applicationId;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public String getVersion() {
        return this.version;
    }

    public BatchApplicationPackageReference setVersion(String version) {
        this.version = version;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("applicationId", this.applicationId);
        jsonWriter.writeStringField("version", this.version);
        return jsonWriter.writeEndObject();
    }

    public static BatchApplicationPackageReference fromJson(JsonReader jsonReader) throws IOException {
        return (BatchApplicationPackageReference)jsonReader.readObject(reader -> {
            String applicationId = null;
            String version = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("applicationId".equals(fieldName)) {
                    applicationId = reader.getString();
                    continue;
                }
                if ("version".equals(fieldName)) {
                    version = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            BatchApplicationPackageReference deserializedBatchApplicationPackageReference = new BatchApplicationPackageReference(applicationId);
            deserializedBatchApplicationPackageReference.version = version;
            return deserializedBatchApplicationPackageReference;
        });
    }
}

