/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class AzureFileShareConfiguration
implements JsonSerializable<AzureFileShareConfiguration> {
    private final String accountName;
    private final String azureFileUrl;
    private final String accountKey;
    private final String relativeMountPath;
    private String mountOptions;

    public AzureFileShareConfiguration(String accountName, String azureFileUrl, String accountKey, String relativeMountPath) {
        this.accountName = accountName;
        this.azureFileUrl = azureFileUrl;
        this.accountKey = accountKey;
        this.relativeMountPath = relativeMountPath;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public String getAzureFileUrl() {
        return this.azureFileUrl;
    }

    public String getAccountKey() {
        return this.accountKey;
    }

    public String getRelativeMountPath() {
        return this.relativeMountPath;
    }

    public String getMountOptions() {
        return this.mountOptions;
    }

    public AzureFileShareConfiguration setMountOptions(String mountOptions) {
        this.mountOptions = mountOptions;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("accountName", this.accountName);
        jsonWriter.writeStringField("azureFileUrl", this.azureFileUrl);
        jsonWriter.writeStringField("accountKey", this.accountKey);
        jsonWriter.writeStringField("relativeMountPath", this.relativeMountPath);
        jsonWriter.writeStringField("mountOptions", this.mountOptions);
        return jsonWriter.writeEndObject();
    }

    public static AzureFileShareConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (AzureFileShareConfiguration)jsonReader.readObject(reader -> {
            String accountName = null;
            String azureFileUrl = null;
            String accountKey = null;
            String relativeMountPath = null;
            String mountOptions = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("accountName".equals(fieldName)) {
                    accountName = reader.getString();
                    continue;
                }
                if ("azureFileUrl".equals(fieldName)) {
                    azureFileUrl = reader.getString();
                    continue;
                }
                if ("accountKey".equals(fieldName)) {
                    accountKey = reader.getString();
                    continue;
                }
                if ("relativeMountPath".equals(fieldName)) {
                    relativeMountPath = reader.getString();
                    continue;
                }
                if ("mountOptions".equals(fieldName)) {
                    mountOptions = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            AzureFileShareConfiguration deserializedAzureFileShareConfiguration = new AzureFileShareConfiguration(accountName, azureFileUrl, accountKey, relativeMountPath);
            deserializedAzureFileShareConfiguration.mountOptions = mountOptions;
            return deserializedAzureFileShareConfiguration;
        });
    }
}

