/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.compute.batch.models.BatchNodeIdentityReference;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class AzureBlobFileSystemConfiguration
implements JsonSerializable<AzureBlobFileSystemConfiguration> {
    private final String accountName;
    private final String containerName;
    private String accountKey;
    private String sasKey;
    private String blobfuseOptions;
    private final String relativeMountPath;
    private BatchNodeIdentityReference identityReference;

    public AzureBlobFileSystemConfiguration(String accountName, String containerName, String relativeMountPath) {
        this.accountName = accountName;
        this.containerName = containerName;
        this.relativeMountPath = relativeMountPath;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public String getContainerName() {
        return this.containerName;
    }

    public String getAccountKey() {
        return this.accountKey;
    }

    public AzureBlobFileSystemConfiguration setAccountKey(String accountKey) {
        this.accountKey = accountKey;
        return this;
    }

    public String getSasKey() {
        return this.sasKey;
    }

    public AzureBlobFileSystemConfiguration setSasKey(String sasKey) {
        this.sasKey = sasKey;
        return this;
    }

    public String getBlobfuseOptions() {
        return this.blobfuseOptions;
    }

    public AzureBlobFileSystemConfiguration setBlobfuseOptions(String blobfuseOptions) {
        this.blobfuseOptions = blobfuseOptions;
        return this;
    }

    public String getRelativeMountPath() {
        return this.relativeMountPath;
    }

    public BatchNodeIdentityReference getIdentityReference() {
        return this.identityReference;
    }

    public AzureBlobFileSystemConfiguration setIdentityReference(BatchNodeIdentityReference identityReference) {
        this.identityReference = identityReference;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("accountName", this.accountName);
        jsonWriter.writeStringField("containerName", this.containerName);
        jsonWriter.writeStringField("relativeMountPath", this.relativeMountPath);
        jsonWriter.writeStringField("accountKey", this.accountKey);
        jsonWriter.writeStringField("sasKey", this.sasKey);
        jsonWriter.writeStringField("blobfuseOptions", this.blobfuseOptions);
        jsonWriter.writeJsonField("identityReference", (JsonSerializable)this.identityReference);
        return jsonWriter.writeEndObject();
    }

    public static AzureBlobFileSystemConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (AzureBlobFileSystemConfiguration)jsonReader.readObject(reader -> {
            String accountName = null;
            String containerName = null;
            String relativeMountPath = null;
            String accountKey = null;
            String sasKey = null;
            String blobfuseOptions = null;
            BatchNodeIdentityReference identityReference = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("accountName".equals(fieldName)) {
                    accountName = reader.getString();
                    continue;
                }
                if ("containerName".equals(fieldName)) {
                    containerName = reader.getString();
                    continue;
                }
                if ("relativeMountPath".equals(fieldName)) {
                    relativeMountPath = reader.getString();
                    continue;
                }
                if ("accountKey".equals(fieldName)) {
                    accountKey = reader.getString();
                    continue;
                }
                if ("sasKey".equals(fieldName)) {
                    sasKey = reader.getString();
                    continue;
                }
                if ("blobfuseOptions".equals(fieldName)) {
                    blobfuseOptions = reader.getString();
                    continue;
                }
                if ("identityReference".equals(fieldName)) {
                    identityReference = BatchNodeIdentityReference.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            AzureBlobFileSystemConfiguration deserializedAzureBlobFileSystemConfiguration = new AzureBlobFileSystemConfiguration(accountName, containerName, relativeMountPath);
            deserializedAzureBlobFileSystemConfiguration.accountKey = accountKey;
            deserializedAzureBlobFileSystemConfiguration.sasKey = sasKey;
            deserializedAzureBlobFileSystemConfiguration.blobfuseOptions = blobfuseOptions;
            deserializedAzureBlobFileSystemConfiguration.identityReference = identityReference;
            return deserializedAzureBlobFileSystemConfiguration;
        });
    }
}

