/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.compute.batch.models.AutoScaleRunError;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class AutoScaleRun
implements JsonSerializable<AutoScaleRun> {
    private final OffsetDateTime timestamp;
    private String results;
    private AutoScaleRunError error;

    private AutoScaleRun(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
    }

    public OffsetDateTime getTimestamp() {
        return this.timestamp;
    }

    public String getResults() {
        return this.results;
    }

    public AutoScaleRunError getError() {
        return this.error;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("timestamp", this.timestamp == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.timestamp));
        jsonWriter.writeStringField("results", this.results);
        jsonWriter.writeJsonField("error", (JsonSerializable)this.error);
        return jsonWriter.writeEndObject();
    }

    public static AutoScaleRun fromJson(JsonReader jsonReader) throws IOException {
        return (AutoScaleRun)jsonReader.readObject(reader -> {
            OffsetDateTime timestamp = null;
            String results = null;
            AutoScaleRunError error = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("timestamp".equals(fieldName)) {
                    timestamp = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("results".equals(fieldName)) {
                    results = reader.getString();
                    continue;
                }
                if ("error".equals(fieldName)) {
                    error = AutoScaleRunError.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            AutoScaleRun deserializedAutoScaleRun = new AutoScaleRun(timestamp);
            deserializedAutoScaleRun.results = results;
            deserializedAutoScaleRun.error = error;
            return deserializedAutoScaleRun;
        });
    }
}

