/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.implementation.task;

import com.azure.compute.batch.BatchClient;
import com.azure.compute.batch.implementation.task.TaskSubmitter;
import com.azure.compute.batch.models.BatchClientParallelOptions;
import com.azure.compute.batch.models.BatchTaskAddResult;
import com.azure.compute.batch.models.BatchTaskAddStatus;
import com.azure.compute.batch.models.BatchTaskCreateContent;
import com.azure.compute.batch.models.BatchTaskGroup;
import com.azure.compute.batch.models.CreateTasksErrorException;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.util.logging.ClientLogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import reactor.core.publisher.Mono;

public class TaskManager {
    public static Mono<Void> createTasks(TaskSubmitter taskSubmitter, String jobId, List<BatchTaskCreateContent> taskList, BatchClientParallelOptions batchClientParallelOptions) {
        ClientLogger logger = new ClientLogger(BatchClient.class);
        return Mono.create(sink -> {
            int threadNumber = 1;
            if (batchClientParallelOptions != null) {
                threadNumber = batchClientParallelOptions.getMaxDegreeOfParallelism();
            }
            Iterator lock = new Iterator();
            ConcurrentLinkedQueue<BatchTaskCreateContent> pendingList = new ConcurrentLinkedQueue<BatchTaskCreateContent>(taskList);
            CopyOnWriteArrayList<BatchTaskAddResult> failures = new CopyOnWriteArrayList<BatchTaskAddResult>();
            HashMap<Object, WorkingThread> threads = new HashMap<Object, WorkingThread>();
            Exception innerException = null;
            Iterator<Object> iterator = lock;
            synchronized (iterator) {
                while (!pendingList.isEmpty()) {
                    if (threads.size() < threadNumber) {
                        WorkingThread worker = new WorkingThread(taskSubmitter, jobId, pendingList, failures, lock);
                        Thread thread = new Thread(worker);
                        thread.start();
                        threads.put(thread, worker);
                        continue;
                    }
                    try {
                        lock.wait();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        sink.error((Throwable)e);
                        return;
                    }
                    ArrayList<Thread> finishedThreads = new ArrayList<Thread>();
                    for (Map.Entry entry : threads.entrySet()) {
                        if (((Thread)entry.getKey()).getState() != Thread.State.TERMINATED) continue;
                        finishedThreads.add((Thread)entry.getKey());
                        innerException = ((WorkingThread)entry.getValue()).getException();
                        if (innerException == null) continue;
                        sink.error((Throwable)innerException);
                        return;
                    }
                    threads.keySet().removeAll(finishedThreads);
                    if (innerException == null && failures.isEmpty()) continue;
                    break;
                }
            }
            for (Thread t : threads.keySet()) {
                try {
                    t.join();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    sink.error((Throwable)e);
                    return;
                }
            }
            if (innerException == null) {
                Map.Entry entry;
                iterator = threads.entrySet().iterator();
                while (iterator.hasNext() && (innerException = ((WorkingThread)(entry = (Map.Entry)iterator.next()).getValue()).getException()) == null) {
                }
            }
            if (innerException != null) {
                if (innerException instanceof HttpResponseException) {
                    throw logger.logExceptionAsError((RuntimeException)((HttpResponseException)innerException));
                }
                if (innerException instanceof RuntimeException) {
                    throw logger.logExceptionAsError((RuntimeException)innerException);
                }
            }
            if (!failures.isEmpty()) {
                ArrayList<BatchTaskCreateContent> notFinished = new ArrayList<BatchTaskCreateContent>(pendingList);
                for (BatchTaskCreateContent param : pendingList) {
                    notFinished.add(param);
                }
                sink.error((Throwable)((Object)new CreateTasksErrorException("At least one task failed to be added.", failures, notFinished)));
            } else {
                sink.success();
            }
        });
    }

    public static class WorkingThread
    implements Runnable {
        static final int MAX_TASKS_PER_REQUEST = 100;
        private static final AtomicInteger CURRENT_MAX_TASKS = new AtomicInteger(100);
        private final TaskSubmitter taskSubmitter;
        private final String jobId;
        private final Queue<BatchTaskCreateContent> pendingList;
        private final List<BatchTaskAddResult> failures;
        private volatile Exception exception;
        private final Object lock;

        public WorkingThread(TaskSubmitter taskSubmitter, String jobId, Queue<BatchTaskCreateContent> pendingList, List<BatchTaskAddResult> failures, Object lock) {
            this.taskSubmitter = taskSubmitter;
            this.jobId = jobId;
            this.pendingList = pendingList;
            this.failures = failures;
            this.exception = null;
            this.lock = lock;
        }

        public Exception getException() {
            return this.exception;
        }

        private void submitChunk(List<BatchTaskCreateContent> taskList) {
            try {
                this.taskSubmitter.submitTasks(this.jobId, new BatchTaskGroup(taskList)).doOnError(e -> {
                    if (e instanceof HttpResponseException) {
                        this.handleException((HttpResponseException)e, taskList);
                    } else {
                        this.exception = (Exception)e;
                        this.pendingList.addAll(taskList);
                    }
                }).subscribe(response -> {
                    if (response != null && response.getValue() != null) {
                        block0: for (BatchTaskAddResult result : response.getValue()) {
                            if (result.getError() == null) continue;
                            if (result.getStatus() == BatchTaskAddStatus.SERVER_ERROR) {
                                for (BatchTaskCreateContent batchTaskToCreate : taskList) {
                                    if (!batchTaskToCreate.getId().equals(result.getTaskId())) continue;
                                    this.pendingList.add(batchTaskToCreate);
                                    continue block0;
                                }
                                continue;
                            }
                            if (result.getStatus() != BatchTaskAddStatus.CLIENT_ERROR || result.getError().getMessage().getValue().contains("Status code 409")) continue;
                            this.failures.add(result);
                        }
                    }
                });
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }

        private void handleException(HttpResponseException e, List<BatchTaskCreateContent> taskList) {
            if (e.getResponse().getStatusCode() == 413 && taskList.size() > 1) {
                int midpoint = taskList.size() / 2;
                int max = CURRENT_MAX_TASKS.get();
                while (midpoint < max) {
                    CURRENT_MAX_TASKS.compareAndSet(max, midpoint);
                    max = CURRENT_MAX_TASKS.get();
                }
                this.pendingList.addAll(taskList.subList(midpoint, taskList.size()));
                this.submitChunk(taskList.subList(0, midpoint));
            } else {
                this.exception = e;
                this.pendingList.addAll(taskList);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                BatchTaskCreateContent param;
                LinkedList<BatchTaskCreateContent> taskList = new LinkedList<BatchTaskCreateContent>();
                int maxAmount = CURRENT_MAX_TASKS.get();
                for (int count = 0; count < maxAmount && (param = this.pendingList.poll()) != null; ++count) {
                    taskList.add(param);
                }
                if (!taskList.isEmpty()) {
                    this.submitChunk(taskList);
                }
            }
            finally {
                Object object = this.lock;
                synchronized (object) {
                    this.lock.notifyAll();
                }
            }
        }
    }
}

