/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.implementation;

import com.azure.core.credential.AzureNamedKeyCredential;
import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.util.DateTimeRfc1123;
import java.io.IOException;
import java.net.URLDecoder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import reactor.core.publisher.Mono;

public final class BatchSharedKeyCredentialsPolicy
implements HttpPipelinePolicy {
    private final AzureNamedKeyCredential azureNamedKeyCredential;
    private Mac hmacSha256;

    public BatchSharedKeyCredentialsPolicy(AzureNamedKeyCredential credential) {
        this.azureNamedKeyCredential = credential;
    }

    private String headerValue(HttpRequest request, HttpHeaderName headerName) {
        HttpHeaders headers = request.getHeaders();
        HttpHeader header = headers.get(headerName);
        if (header == null) {
            return "";
        }
        return header.getValue();
    }

    private synchronized String sign(String stringToSign) {
        try {
            byte[] digest = this.getHmac256().doFinal(stringToSign.getBytes("UTF-8"));
            return Base64.getEncoder().encodeToString(digest);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("accessKey", e);
        }
    }

    private synchronized Mac getHmac256() throws NoSuchAlgorithmException, InvalidKeyException {
        if (this.hmacSha256 == null) {
            byte[] key = Base64.getDecoder().decode(this.azureNamedKeyCredential.getAzureNamedKey().getKey());
            this.hmacSha256 = Mac.getInstance("HmacSHA256");
            this.hmacSha256.init(new SecretKeySpec(key, "HmacSHA256"));
        }
        return this.hmacSha256;
    }

    public String signHeader(HttpRequest request) throws IOException {
        String dateHeaderToSign = this.headerValue(request, HttpHeaderName.DATE);
        HttpHeaderName ocpDateHeader = HttpHeaderName.fromString((String)"ocp-date");
        if (request.getHeaders().get(ocpDateHeader) == null) {
            if (dateHeaderToSign == null) {
                DateTimeRfc1123 rfcDate = new DateTimeRfc1123(OffsetDateTime.now());
                request.setHeader(ocpDateHeader, rfcDate.toString());
                dateHeaderToSign = "";
            }
        } else {
            dateHeaderToSign = "";
        }
        StringBuffer signature = new StringBuffer(request.getHttpMethod().toString());
        signature.append("\n");
        signature.append(this.headerValue(request, HttpHeaderName.CONTENT_ENCODING)).append("\n");
        signature.append(this.headerValue(request, HttpHeaderName.CONTENT_LANGUAGE)).append("\n");
        String contentLength = this.headerValue(request, HttpHeaderName.CONTENT_LENGTH);
        signature.append(contentLength == null || Long.parseLong(contentLength) < 0L ? "" : contentLength).append("\n");
        signature.append(this.headerValue(request, HttpHeaderName.CONTENT_MD5)).append("\n");
        String contentType = this.headerValue(request, HttpHeaderName.CONTENT_TYPE);
        signature.append(contentType).append("\n");
        signature.append(dateHeaderToSign).append("\n");
        signature.append(this.headerValue(request, HttpHeaderName.IF_MODIFIED_SINCE)).append("\n");
        signature.append(this.headerValue(request, HttpHeaderName.IF_MATCH)).append("\n");
        signature.append(this.headerValue(request, HttpHeaderName.IF_NONE_MATCH)).append("\n");
        signature.append(this.headerValue(request, HttpHeaderName.IF_UNMODIFIED_SINCE)).append("\n");
        signature.append(this.headerValue(request, HttpHeaderName.RANGE)).append("\n");
        ArrayList<String> customHeaders = new ArrayList<String>();
        for (HttpHeader name : request.getHeaders()) {
            if (!name.getName().toLowerCase(Locale.ROOT).startsWith("ocp-")) continue;
            customHeaders.add(name.getName().toLowerCase(Locale.ROOT));
        }
        Collections.sort(customHeaders);
        for (String canonicalHeader : customHeaders) {
            String value = request.getHeaders().getValue(HttpHeaderName.fromString((String)canonicalHeader));
            value = value.replace('\n', ' ').replace('\r', ' ').replaceAll("^[ ]+", "");
            signature.append(canonicalHeader).append(":").append(value).append("\n");
        }
        signature.append("/").append(this.azureNamedKeyCredential.getAzureNamedKey().getName().toLowerCase(Locale.ROOT)).append("/").append(request.getUrl().getPath().replaceAll("^[/]+", ""));
        String query = request.getUrl().getQuery();
        if (query != null) {
            TreeMap<String, String> queryComponents = new TreeMap<String, String>();
            String[] pairs = query.split("&");
            for (String pair : pairs) {
                int idx = pair.indexOf("=");
                String key = URLDecoder.decode(pair.substring(0, idx), "UTF-8").toLowerCase(Locale.US);
                queryComponents.put(key, key + ":" + URLDecoder.decode(pair.substring(idx + 1), "UTF-8"));
            }
            for (Map.Entry entry : queryComponents.entrySet()) {
                signature.append("\n").append((String)entry.getValue());
            }
        }
        String signedSignature = this.sign(signature.toString());
        String authorization = "SharedKey " + this.azureNamedKeyCredential.getAzureNamedKey().getName() + ":" + signedSignature;
        return authorization;
    }

    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        try {
            String authorizationValue = this.signHeader(context.getHttpRequest());
            context.getHttpRequest().setHeader(HttpHeaderName.fromString((String)"Authorization"), authorizationValue);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return next.process();
    }
}

