/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch;

import com.azure.compute.batch.BatchClientBuilder;
import com.azure.compute.batch.implementation.BatchClientImpl;
import com.azure.compute.batch.implementation.task.AsyncTaskSubmitter;
import com.azure.compute.batch.implementation.task.TaskManager;
import com.azure.compute.batch.models.AutoScaleRun;
import com.azure.compute.batch.models.BatchApplication;
import com.azure.compute.batch.models.BatchCertificate;
import com.azure.compute.batch.models.BatchClientParallelOptions;
import com.azure.compute.batch.models.BatchJob;
import com.azure.compute.batch.models.BatchJobCreateContent;
import com.azure.compute.batch.models.BatchJobDisableContent;
import com.azure.compute.batch.models.BatchJobPreparationAndReleaseTaskStatus;
import com.azure.compute.batch.models.BatchJobSchedule;
import com.azure.compute.batch.models.BatchJobScheduleCreateContent;
import com.azure.compute.batch.models.BatchJobScheduleExistsOptions;
import com.azure.compute.batch.models.BatchJobScheduleUpdateContent;
import com.azure.compute.batch.models.BatchJobTerminateContent;
import com.azure.compute.batch.models.BatchJobUpdateContent;
import com.azure.compute.batch.models.BatchNode;
import com.azure.compute.batch.models.BatchNodeDeallocateContent;
import com.azure.compute.batch.models.BatchNodeDisableSchedulingContent;
import com.azure.compute.batch.models.BatchNodeFile;
import com.azure.compute.batch.models.BatchNodeRebootContent;
import com.azure.compute.batch.models.BatchNodeReimageContent;
import com.azure.compute.batch.models.BatchNodeRemoteLoginSettings;
import com.azure.compute.batch.models.BatchNodeRemoveContent;
import com.azure.compute.batch.models.BatchNodeUserCreateContent;
import com.azure.compute.batch.models.BatchNodeUserUpdateContent;
import com.azure.compute.batch.models.BatchNodeVMExtension;
import com.azure.compute.batch.models.BatchPool;
import com.azure.compute.batch.models.BatchPoolCreateContent;
import com.azure.compute.batch.models.BatchPoolEnableAutoScaleContent;
import com.azure.compute.batch.models.BatchPoolEvaluateAutoScaleContent;
import com.azure.compute.batch.models.BatchPoolExistsOptions;
import com.azure.compute.batch.models.BatchPoolNodeCounts;
import com.azure.compute.batch.models.BatchPoolReplaceContent;
import com.azure.compute.batch.models.BatchPoolResizeContent;
import com.azure.compute.batch.models.BatchPoolUpdateContent;
import com.azure.compute.batch.models.BatchPoolUsageMetrics;
import com.azure.compute.batch.models.BatchSubtask;
import com.azure.compute.batch.models.BatchSupportedImage;
import com.azure.compute.batch.models.BatchTask;
import com.azure.compute.batch.models.BatchTaskAddCollectionResult;
import com.azure.compute.batch.models.BatchTaskCountsResult;
import com.azure.compute.batch.models.BatchTaskCreateContent;
import com.azure.compute.batch.models.BatchTaskGroup;
import com.azure.compute.batch.models.CancelBatchCertificateDeletionOptions;
import com.azure.compute.batch.models.CreateBatchCertificateOptions;
import com.azure.compute.batch.models.CreateBatchJobOptions;
import com.azure.compute.batch.models.CreateBatchJobScheduleOptions;
import com.azure.compute.batch.models.CreateBatchNodeUserOptions;
import com.azure.compute.batch.models.CreateBatchPoolOptions;
import com.azure.compute.batch.models.CreateBatchTaskCollectionOptions;
import com.azure.compute.batch.models.CreateBatchTaskOptions;
import com.azure.compute.batch.models.DeallocateBatchNodeOptions;
import com.azure.compute.batch.models.DeleteBatchCertificateOptions;
import com.azure.compute.batch.models.DeleteBatchJobOptions;
import com.azure.compute.batch.models.DeleteBatchJobScheduleOptions;
import com.azure.compute.batch.models.DeleteBatchNodeFileOptions;
import com.azure.compute.batch.models.DeleteBatchNodeUserOptions;
import com.azure.compute.batch.models.DeleteBatchPoolOptions;
import com.azure.compute.batch.models.DeleteBatchTaskFileOptions;
import com.azure.compute.batch.models.DeleteBatchTaskOptions;
import com.azure.compute.batch.models.DisableBatchJobOptions;
import com.azure.compute.batch.models.DisableBatchJobScheduleOptions;
import com.azure.compute.batch.models.DisableBatchNodeSchedulingOptions;
import com.azure.compute.batch.models.DisableBatchPoolAutoScaleOptions;
import com.azure.compute.batch.models.EnableBatchJobOptions;
import com.azure.compute.batch.models.EnableBatchJobScheduleOptions;
import com.azure.compute.batch.models.EnableBatchNodeSchedulingOptions;
import com.azure.compute.batch.models.EnableBatchPoolAutoScaleOptions;
import com.azure.compute.batch.models.EvaluateBatchPoolAutoScaleOptions;
import com.azure.compute.batch.models.FileResponseHeaderProperties;
import com.azure.compute.batch.models.GetBatchApplicationOptions;
import com.azure.compute.batch.models.GetBatchCertificateOptions;
import com.azure.compute.batch.models.GetBatchJobOptions;
import com.azure.compute.batch.models.GetBatchJobScheduleOptions;
import com.azure.compute.batch.models.GetBatchJobTaskCountsOptions;
import com.azure.compute.batch.models.GetBatchNodeExtensionOptions;
import com.azure.compute.batch.models.GetBatchNodeFileOptions;
import com.azure.compute.batch.models.GetBatchNodeFilePropertiesOptions;
import com.azure.compute.batch.models.GetBatchNodeOptions;
import com.azure.compute.batch.models.GetBatchNodeRemoteLoginSettingsOptions;
import com.azure.compute.batch.models.GetBatchPoolOptions;
import com.azure.compute.batch.models.GetBatchTaskFileOptions;
import com.azure.compute.batch.models.GetBatchTaskFilePropertiesOptions;
import com.azure.compute.batch.models.GetBatchTaskOptions;
import com.azure.compute.batch.models.GetCertificateResponse;
import com.azure.compute.batch.models.ListBatchApplicationsOptions;
import com.azure.compute.batch.models.ListBatchCertificatesOptions;
import com.azure.compute.batch.models.ListBatchJobPreparationAndReleaseTaskStatusOptions;
import com.azure.compute.batch.models.ListBatchJobSchedulesOptions;
import com.azure.compute.batch.models.ListBatchJobsFromScheduleOptions;
import com.azure.compute.batch.models.ListBatchJobsOptions;
import com.azure.compute.batch.models.ListBatchNodeExtensionsOptions;
import com.azure.compute.batch.models.ListBatchNodeFilesOptions;
import com.azure.compute.batch.models.ListBatchNodesOptions;
import com.azure.compute.batch.models.ListBatchPoolNodeCountsOptions;
import com.azure.compute.batch.models.ListBatchPoolUsageMetricsOptions;
import com.azure.compute.batch.models.ListBatchPoolsOptions;
import com.azure.compute.batch.models.ListBatchSubTasksOptions;
import com.azure.compute.batch.models.ListBatchTaskFilesOptions;
import com.azure.compute.batch.models.ListBatchTasksOptions;
import com.azure.compute.batch.models.ListSupportedBatchImagesOptions;
import com.azure.compute.batch.models.ReactivateBatchTaskOptions;
import com.azure.compute.batch.models.RebootBatchNodeOptions;
import com.azure.compute.batch.models.ReimageBatchNodeOptions;
import com.azure.compute.batch.models.RemoveBatchNodesOptions;
import com.azure.compute.batch.models.ReplaceBatchJobOptions;
import com.azure.compute.batch.models.ReplaceBatchJobScheduleOptions;
import com.azure.compute.batch.models.ReplaceBatchNodeUserOptions;
import com.azure.compute.batch.models.ReplaceBatchPoolPropertiesOptions;
import com.azure.compute.batch.models.ReplaceBatchTaskOptions;
import com.azure.compute.batch.models.ResizeBatchPoolOptions;
import com.azure.compute.batch.models.StartBatchNodeOptions;
import com.azure.compute.batch.models.StopBatchPoolResizeOptions;
import com.azure.compute.batch.models.TerminateBatchJobOptions;
import com.azure.compute.batch.models.TerminateBatchJobScheduleOptions;
import com.azure.compute.batch.models.TerminateBatchTaskOptions;
import com.azure.compute.batch.models.UpdateBatchJobOptions;
import com.azure.compute.batch.models.UpdateBatchJobScheduleOptions;
import com.azure.compute.batch.models.UpdateBatchPoolOptions;
import com.azure.compute.batch.models.UploadBatchNodeLogsOptions;
import com.azure.compute.batch.models.UploadBatchServiceLogsContent;
import com.azure.compute.batch.models.UploadBatchServiceLogsResult;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.RequestConditions;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.core.util.FluxUtil;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ServiceClient(builder=BatchClientBuilder.class, isAsync=true)
public final class BatchAsyncClient {
    private final BatchClientImpl serviceClient;

    BatchAsyncClient(BatchClientImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> createTasks(String jobId, List<BatchTaskCreateContent> taskList) {
        return this.createTasks(jobId, taskList, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> createTasks(String jobId, List<BatchTaskCreateContent> taskList, BatchClientParallelOptions batchClientParallelOptions) {
        AsyncTaskSubmitter taskSubmitter = new AsyncTaskSubmitter(this);
        return TaskManager.createTasks(taskSubmitter, jobId, taskList, batchClientParallelOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listApplications(RequestOptions requestOptions) {
        return this.serviceClient.listApplicationsAsync(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getApplicationWithResponse(String applicationId, RequestOptions requestOptions) {
        return this.serviceClient.getApplicationWithResponseAsync(applicationId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listPoolUsageMetrics(RequestOptions requestOptions) {
        return this.serviceClient.listPoolUsageMetricsAsync(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> createPoolWithResponse(BinaryData pool, RequestOptions requestOptions) {
        return this.serviceClient.createPoolWithResponseAsync(pool, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listPools(RequestOptions requestOptions) {
        return this.serviceClient.listPoolsAsync(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deletePoolWithResponse(String poolId, RequestOptions requestOptions) {
        return this.serviceClient.deletePoolWithResponseAsync(poolId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Boolean>> poolExistsWithResponse(String poolId, RequestOptions requestOptions) {
        return this.serviceClient.poolExistsWithResponseAsync(poolId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getPoolWithResponse(String poolId, RequestOptions requestOptions) {
        return this.serviceClient.getPoolWithResponseAsync(poolId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> updatePoolWithResponse(String poolId, BinaryData pool, RequestOptions requestOptions) {
        return this.serviceClient.updatePoolWithResponseAsync(poolId, pool, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> disablePoolAutoScaleWithResponse(String poolId, RequestOptions requestOptions) {
        return this.serviceClient.disablePoolAutoScaleWithResponseAsync(poolId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> enablePoolAutoScaleWithResponse(String poolId, BinaryData content, RequestOptions requestOptions) {
        return this.serviceClient.enablePoolAutoScaleWithResponseAsync(poolId, content, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> evaluatePoolAutoScaleWithResponse(String poolId, BinaryData content, RequestOptions requestOptions) {
        return this.serviceClient.evaluatePoolAutoScaleWithResponseAsync(poolId, content, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> resizePoolWithResponse(String poolId, BinaryData content, RequestOptions requestOptions) {
        return this.serviceClient.resizePoolWithResponseAsync(poolId, content, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> stopPoolResizeWithResponse(String poolId, RequestOptions requestOptions) {
        return this.serviceClient.stopPoolResizeWithResponseAsync(poolId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> replacePoolPropertiesWithResponse(String poolId, BinaryData pool, RequestOptions requestOptions) {
        return this.serviceClient.replacePoolPropertiesWithResponseAsync(poolId, pool, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> removeNodesWithResponse(String poolId, BinaryData content, RequestOptions requestOptions) {
        return this.serviceClient.removeNodesWithResponseAsync(poolId, content, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listSupportedImages(RequestOptions requestOptions) {
        return this.serviceClient.listSupportedImagesAsync(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listPoolNodeCounts(RequestOptions requestOptions) {
        return this.serviceClient.listPoolNodeCountsAsync(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteJobWithResponse(String jobId, RequestOptions requestOptions) {
        return this.serviceClient.deleteJobWithResponseAsync(jobId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getJobWithResponse(String jobId, RequestOptions requestOptions) {
        return this.serviceClient.getJobWithResponseAsync(jobId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> updateJobWithResponse(String jobId, BinaryData job, RequestOptions requestOptions) {
        return this.serviceClient.updateJobWithResponseAsync(jobId, job, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> replaceJobWithResponse(String jobId, BinaryData job, RequestOptions requestOptions) {
        return this.serviceClient.replaceJobWithResponseAsync(jobId, job, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> disableJobWithResponse(String jobId, BinaryData content, RequestOptions requestOptions) {
        return this.serviceClient.disableJobWithResponseAsync(jobId, content, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> enableJobWithResponse(String jobId, RequestOptions requestOptions) {
        return this.serviceClient.enableJobWithResponseAsync(jobId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> terminateJobWithResponse(String jobId, RequestOptions requestOptions) {
        return this.serviceClient.terminateJobWithResponseAsync(jobId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> createJobWithResponse(BinaryData job, RequestOptions requestOptions) {
        return this.serviceClient.createJobWithResponseAsync(job, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listJobs(RequestOptions requestOptions) {
        return this.serviceClient.listJobsAsync(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listJobsFromSchedule(String jobScheduleId, RequestOptions requestOptions) {
        return this.serviceClient.listJobsFromScheduleAsync(jobScheduleId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listJobPreparationAndReleaseTaskStatus(String jobId, RequestOptions requestOptions) {
        return this.serviceClient.listJobPreparationAndReleaseTaskStatusAsync(jobId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getJobTaskCountsWithResponse(String jobId, RequestOptions requestOptions) {
        return this.serviceClient.getJobTaskCountsWithResponseAsync(jobId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> createCertificateWithResponse(BinaryData certificate, RequestOptions requestOptions) {
        return this.serviceClient.createCertificateWithResponseAsync(certificate, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listCertificates(RequestOptions requestOptions) {
        return this.serviceClient.listCertificatesAsync(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> cancelCertificateDeletionWithResponse(String thumbprintAlgorithm, String thumbprint, RequestOptions requestOptions) {
        return this.serviceClient.cancelCertificateDeletionWithResponseAsync(thumbprintAlgorithm, thumbprint, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteCertificateWithResponse(String thumbprintAlgorithm, String thumbprint, RequestOptions requestOptions) {
        return this.serviceClient.deleteCertificateWithResponseAsync(thumbprintAlgorithm, thumbprint, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getCertificateWithResponse(String thumbprintAlgorithm, String thumbprint, RequestOptions requestOptions) {
        return this.serviceClient.getCertificateWithResponseAsync(thumbprintAlgorithm, thumbprint, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Boolean>> jobScheduleExistsWithResponse(String jobScheduleId, RequestOptions requestOptions) {
        return this.serviceClient.jobScheduleExistsWithResponseAsync(jobScheduleId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteJobScheduleWithResponse(String jobScheduleId, RequestOptions requestOptions) {
        return this.serviceClient.deleteJobScheduleWithResponseAsync(jobScheduleId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getJobScheduleWithResponse(String jobScheduleId, RequestOptions requestOptions) {
        return this.serviceClient.getJobScheduleWithResponseAsync(jobScheduleId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> updateJobScheduleWithResponse(String jobScheduleId, BinaryData jobSchedule, RequestOptions requestOptions) {
        return this.serviceClient.updateJobScheduleWithResponseAsync(jobScheduleId, jobSchedule, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> replaceJobScheduleWithResponse(String jobScheduleId, BinaryData jobSchedule, RequestOptions requestOptions) {
        return this.serviceClient.replaceJobScheduleWithResponseAsync(jobScheduleId, jobSchedule, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> disableJobScheduleWithResponse(String jobScheduleId, RequestOptions requestOptions) {
        return this.serviceClient.disableJobScheduleWithResponseAsync(jobScheduleId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> enableJobScheduleWithResponse(String jobScheduleId, RequestOptions requestOptions) {
        return this.serviceClient.enableJobScheduleWithResponseAsync(jobScheduleId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> terminateJobScheduleWithResponse(String jobScheduleId, RequestOptions requestOptions) {
        return this.serviceClient.terminateJobScheduleWithResponseAsync(jobScheduleId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> createJobScheduleWithResponse(BinaryData jobSchedule, RequestOptions requestOptions) {
        return this.serviceClient.createJobScheduleWithResponseAsync(jobSchedule, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listJobSchedules(RequestOptions requestOptions) {
        return this.serviceClient.listJobSchedulesAsync(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> createTaskWithResponse(String jobId, BinaryData task, RequestOptions requestOptions) {
        return this.serviceClient.createTaskWithResponseAsync(jobId, task, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listTasks(String jobId, RequestOptions requestOptions) {
        return this.serviceClient.listTasksAsync(jobId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> createTaskCollectionWithResponse(String jobId, BinaryData taskCollection, RequestOptions requestOptions) {
        return this.serviceClient.createTaskCollectionWithResponseAsync(jobId, taskCollection, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteTaskWithResponse(String jobId, String taskId, RequestOptions requestOptions) {
        return this.serviceClient.deleteTaskWithResponseAsync(jobId, taskId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getTaskWithResponse(String jobId, String taskId, RequestOptions requestOptions) {
        return this.serviceClient.getTaskWithResponseAsync(jobId, taskId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> replaceTaskWithResponse(String jobId, String taskId, BinaryData task, RequestOptions requestOptions) {
        return this.serviceClient.replaceTaskWithResponseAsync(jobId, taskId, task, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listSubTasks(String jobId, String taskId, RequestOptions requestOptions) {
        return this.serviceClient.listSubTasksAsync(jobId, taskId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> terminateTaskWithResponse(String jobId, String taskId, RequestOptions requestOptions) {
        return this.serviceClient.terminateTaskWithResponseAsync(jobId, taskId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> reactivateTaskWithResponse(String jobId, String taskId, RequestOptions requestOptions) {
        return this.serviceClient.reactivateTaskWithResponseAsync(jobId, taskId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteTaskFileWithResponse(String jobId, String taskId, String filePath, RequestOptions requestOptions) {
        return this.serviceClient.deleteTaskFileWithResponseAsync(jobId, taskId, filePath, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getTaskFileWithResponse(String jobId, String taskId, String filePath, RequestOptions requestOptions) {
        return this.serviceClient.getTaskFileWithResponseAsync(jobId, taskId, filePath, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> getTaskFilePropertiesWithResponse(String jobId, String taskId, String filePath, RequestOptions requestOptions) {
        return this.serviceClient.getTaskFilePropertiesWithResponseAsync(jobId, taskId, filePath, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listTaskFiles(String jobId, String taskId, RequestOptions requestOptions) {
        return this.serviceClient.listTaskFilesAsync(jobId, taskId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> createNodeUserWithResponse(String poolId, String nodeId, BinaryData user, RequestOptions requestOptions) {
        return this.serviceClient.createNodeUserWithResponseAsync(poolId, nodeId, user, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteNodeUserWithResponse(String poolId, String nodeId, String userName, RequestOptions requestOptions) {
        return this.serviceClient.deleteNodeUserWithResponseAsync(poolId, nodeId, userName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> replaceNodeUserWithResponse(String poolId, String nodeId, String userName, BinaryData content, RequestOptions requestOptions) {
        return this.serviceClient.replaceNodeUserWithResponseAsync(poolId, nodeId, userName, content, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getNodeWithResponse(String poolId, String nodeId, RequestOptions requestOptions) {
        return this.serviceClient.getNodeWithResponseAsync(poolId, nodeId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> rebootNodeWithResponse(String poolId, String nodeId, RequestOptions requestOptions) {
        return this.serviceClient.rebootNodeWithResponseAsync(poolId, nodeId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> startNodeWithResponse(String poolId, String nodeId, RequestOptions requestOptions) {
        return this.serviceClient.startNodeWithResponseAsync(poolId, nodeId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> reimageNodeWithResponse(String poolId, String nodeId, RequestOptions requestOptions) {
        return this.serviceClient.reimageNodeWithResponseAsync(poolId, nodeId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deallocateNodeWithResponse(String poolId, String nodeId, RequestOptions requestOptions) {
        return this.serviceClient.deallocateNodeWithResponseAsync(poolId, nodeId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> disableNodeSchedulingWithResponse(String poolId, String nodeId, RequestOptions requestOptions) {
        return this.serviceClient.disableNodeSchedulingWithResponseAsync(poolId, nodeId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> enableNodeSchedulingWithResponse(String poolId, String nodeId, RequestOptions requestOptions) {
        return this.serviceClient.enableNodeSchedulingWithResponseAsync(poolId, nodeId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getNodeRemoteLoginSettingsWithResponse(String poolId, String nodeId, RequestOptions requestOptions) {
        return this.serviceClient.getNodeRemoteLoginSettingsWithResponseAsync(poolId, nodeId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> uploadNodeLogsWithResponse(String poolId, String nodeId, BinaryData content, RequestOptions requestOptions) {
        return this.serviceClient.uploadNodeLogsWithResponseAsync(poolId, nodeId, content, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listNodes(String poolId, RequestOptions requestOptions) {
        return this.serviceClient.listNodesAsync(poolId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getNodeExtensionWithResponse(String poolId, String nodeId, String extensionName, RequestOptions requestOptions) {
        return this.serviceClient.getNodeExtensionWithResponseAsync(poolId, nodeId, extensionName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listNodeExtensions(String poolId, String nodeId, RequestOptions requestOptions) {
        return this.serviceClient.listNodeExtensionsAsync(poolId, nodeId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteNodeFileWithResponse(String poolId, String nodeId, String filePath, RequestOptions requestOptions) {
        return this.serviceClient.deleteNodeFileWithResponseAsync(poolId, nodeId, filePath, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getNodeFileWithResponse(String poolId, String nodeId, String filePath, RequestOptions requestOptions) {
        return this.serviceClient.getNodeFileWithResponseAsync(poolId, nodeId, filePath, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> getNodeFilePropertiesWithResponse(String poolId, String nodeId, String filePath, RequestOptions requestOptions) {
        return this.serviceClient.getNodeFilePropertiesWithResponseAsync(poolId, nodeId, filePath, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listNodeFiles(String poolId, String nodeId, RequestOptions requestOptions) {
        return this.serviceClient.listNodeFilesAsync(poolId, nodeId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BatchApplication> listApplications(ListBatchApplicationsOptions options) {
        Integer timeOutInSeconds;
        RequestOptions requestOptions = new RequestOptions();
        Integer n = timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        PagedFlux<BinaryData> pagedFluxResponse = this.listApplications(requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (BatchApplication)protocolMethodData.toObject(BatchApplication.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BatchApplication> listApplications() {
        RequestOptions requestOptions = new RequestOptions();
        PagedFlux<BinaryData> pagedFluxResponse = this.listApplications(requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (BatchApplication)protocolMethodData.toObject(BatchApplication.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BatchApplication> getApplication(String applicationId, GetBatchApplicationOptions options) {
        Integer timeOutInSeconds;
        RequestOptions requestOptions = new RequestOptions();
        Integer n = timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        return this.getApplicationWithResponse(applicationId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (BatchApplication)protocolMethodData.toObject(BatchApplication.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BatchApplication> getApplication(String applicationId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getApplicationWithResponse(applicationId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (BatchApplication)protocolMethodData.toObject(BatchApplication.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BatchPoolUsageMetrics> listPoolUsageMetrics(ListBatchPoolUsageMetricsOptions options) {
        String filter;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime startTime = options == null ? null : options.getStartTime();
        OffsetDateTime endtime = options == null ? null : options.getEndtime();
        String string = filter = options == null ? null : options.getFilter();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (startTime != null) {
            requestOptions.addQueryParam("startTime", String.valueOf(startTime), false);
        }
        if (endtime != null) {
            requestOptions.addQueryParam("endtime", String.valueOf(endtime), false);
        }
        if (filter != null) {
            requestOptions.addQueryParam("$filter", filter, false);
        }
        PagedFlux<BinaryData> pagedFluxResponse = this.listPoolUsageMetrics(requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (BatchPoolUsageMetrics)protocolMethodData.toObject(BatchPoolUsageMetrics.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BatchPoolUsageMetrics> listPoolUsageMetrics() {
        RequestOptions requestOptions = new RequestOptions();
        PagedFlux<BinaryData> pagedFluxResponse = this.listPoolUsageMetrics(requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (BatchPoolUsageMetrics)protocolMethodData.toObject(BatchPoolUsageMetrics.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> createPool(BatchPoolCreateContent pool, CreateBatchPoolOptions options) {
        Integer timeOutInSeconds;
        RequestOptions requestOptions = new RequestOptions();
        Integer n = timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        return this.createPoolWithResponse(BinaryData.fromObject((Object)pool), requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> createPool(BatchPoolCreateContent pool) {
        RequestOptions requestOptions = new RequestOptions();
        return this.createPoolWithResponse(BinaryData.fromObject((Object)pool), requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BatchPool> listPools(ListBatchPoolsOptions options) {
        List<String> expand;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        String filter = options == null ? null : options.getFilter();
        List<String> select = options == null ? null : options.getSelect();
        List<String> list = expand = options == null ? null : options.getExpand();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (filter != null) {
            requestOptions.addQueryParam("$filter", filter, false);
        }
        if (select != null) {
            requestOptions.addQueryParam("$select", select.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        if (expand != null) {
            requestOptions.addQueryParam("$expand", expand.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        PagedFlux<BinaryData> pagedFluxResponse = this.listPools(requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (BatchPool)protocolMethodData.toObject(BatchPool.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BatchPool> listPools() {
        RequestOptions requestOptions = new RequestOptions();
        PagedFlux<BinaryData> pagedFluxResponse = this.listPools(requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (BatchPool)protocolMethodData.toObject(BatchPool.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deletePool(String poolId, DeleteBatchPoolOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        return this.deletePoolWithResponse(poolId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deletePool(String poolId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.deletePoolWithResponse(poolId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Boolean> poolExists(String poolId, BatchPoolExistsOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        return this.poolExistsWithResponse(poolId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Boolean> poolExists(String poolId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.poolExistsWithResponse(poolId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BatchPool> getPool(String poolId, GetBatchPoolOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        List<String> select = options == null ? null : options.getSelect();
        List<String> expand = options == null ? null : options.getExpand();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (select != null) {
            requestOptions.addQueryParam("$select", select.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        if (expand != null) {
            requestOptions.addQueryParam("$expand", expand.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        return this.getPoolWithResponse(poolId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (BatchPool)protocolMethodData.toObject(BatchPool.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BatchPool> getPool(String poolId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getPoolWithResponse(poolId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (BatchPool)protocolMethodData.toObject(BatchPool.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> updatePool(String poolId, BatchPoolUpdateContent pool, UpdateBatchPoolOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        return this.updatePoolWithResponse(poolId, BinaryData.fromObject((Object)pool), requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> updatePool(String poolId, BatchPoolUpdateContent pool) {
        RequestOptions requestOptions = new RequestOptions();
        return this.updatePoolWithResponse(poolId, BinaryData.fromObject((Object)pool), requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> disablePoolAutoScale(String poolId, DisableBatchPoolAutoScaleOptions options) {
        Integer timeOutInSeconds;
        RequestOptions requestOptions = new RequestOptions();
        Integer n = timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        return this.disablePoolAutoScaleWithResponse(poolId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> disablePoolAutoScale(String poolId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.disablePoolAutoScaleWithResponse(poolId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> enablePoolAutoScale(String poolId, BatchPoolEnableAutoScaleContent content, EnableBatchPoolAutoScaleOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        return this.enablePoolAutoScaleWithResponse(poolId, BinaryData.fromObject((Object)content), requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> enablePoolAutoScale(String poolId, BatchPoolEnableAutoScaleContent content) {
        RequestOptions requestOptions = new RequestOptions();
        return this.enablePoolAutoScaleWithResponse(poolId, BinaryData.fromObject((Object)content), requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AutoScaleRun> evaluatePoolAutoScale(String poolId, BatchPoolEvaluateAutoScaleContent content, EvaluateBatchPoolAutoScaleOptions options) {
        Integer timeOutInSeconds;
        RequestOptions requestOptions = new RequestOptions();
        Integer n = timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        return this.evaluatePoolAutoScaleWithResponse(poolId, BinaryData.fromObject((Object)content), requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (AutoScaleRun)protocolMethodData.toObject(AutoScaleRun.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AutoScaleRun> evaluatePoolAutoScale(String poolId, BatchPoolEvaluateAutoScaleContent content) {
        RequestOptions requestOptions = new RequestOptions();
        return this.evaluatePoolAutoScaleWithResponse(poolId, BinaryData.fromObject((Object)content), requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (AutoScaleRun)protocolMethodData.toObject(AutoScaleRun.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> resizePool(String poolId, BatchPoolResizeContent content, ResizeBatchPoolOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        return this.resizePoolWithResponse(poolId, BinaryData.fromObject((Object)content), requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> resizePool(String poolId, BatchPoolResizeContent content) {
        RequestOptions requestOptions = new RequestOptions();
        return this.resizePoolWithResponse(poolId, BinaryData.fromObject((Object)content), requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> stopPoolResize(String poolId, StopBatchPoolResizeOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        return this.stopPoolResizeWithResponse(poolId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> stopPoolResize(String poolId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.stopPoolResizeWithResponse(poolId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> replacePoolProperties(String poolId, BatchPoolReplaceContent pool, ReplaceBatchPoolPropertiesOptions options) {
        Integer timeOutInSeconds;
        RequestOptions requestOptions = new RequestOptions();
        Integer n = timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        return this.replacePoolPropertiesWithResponse(poolId, BinaryData.fromObject((Object)pool), requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> replacePoolProperties(String poolId, BatchPoolReplaceContent pool) {
        RequestOptions requestOptions = new RequestOptions();
        return this.replacePoolPropertiesWithResponse(poolId, BinaryData.fromObject((Object)pool), requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> removeNodes(String poolId, BatchNodeRemoveContent content, RemoveBatchNodesOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        return this.removeNodesWithResponse(poolId, BinaryData.fromObject((Object)content), requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> removeNodes(String poolId, BatchNodeRemoveContent content) {
        RequestOptions requestOptions = new RequestOptions();
        return this.removeNodesWithResponse(poolId, BinaryData.fromObject((Object)content), requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BatchSupportedImage> listSupportedImages(ListSupportedBatchImagesOptions options) {
        String filter;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        String string = filter = options == null ? null : options.getFilter();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (filter != null) {
            requestOptions.addQueryParam("$filter", filter, false);
        }
        PagedFlux<BinaryData> pagedFluxResponse = this.listSupportedImages(requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (BatchSupportedImage)protocolMethodData.toObject(BatchSupportedImage.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BatchSupportedImage> listSupportedImages() {
        RequestOptions requestOptions = new RequestOptions();
        PagedFlux<BinaryData> pagedFluxResponse = this.listSupportedImages(requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (BatchSupportedImage)protocolMethodData.toObject(BatchSupportedImage.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BatchPoolNodeCounts> listPoolNodeCounts(ListBatchPoolNodeCountsOptions options) {
        String filter;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        String string = filter = options == null ? null : options.getFilter();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (filter != null) {
            requestOptions.addQueryParam("$filter", filter, false);
        }
        PagedFlux<BinaryData> pagedFluxResponse = this.listPoolNodeCounts(requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (BatchPoolNodeCounts)protocolMethodData.toObject(BatchPoolNodeCounts.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BatchPoolNodeCounts> listPoolNodeCounts() {
        RequestOptions requestOptions = new RequestOptions();
        PagedFlux<BinaryData> pagedFluxResponse = this.listPoolNodeCounts(requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (BatchPoolNodeCounts)protocolMethodData.toObject(BatchPoolNodeCounts.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteJob(String jobId, DeleteBatchJobOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        Boolean force = options == null ? null : options.isForce();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (force != null) {
            requestOptions.addQueryParam("force", String.valueOf(force), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        return this.deleteJobWithResponse(jobId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteJob(String jobId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.deleteJobWithResponse(jobId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BatchJob> getJob(String jobId, GetBatchJobOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        List<String> select = options == null ? null : options.getSelect();
        List<String> expand = options == null ? null : options.getExpand();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (select != null) {
            requestOptions.addQueryParam("$select", select.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        if (expand != null) {
            requestOptions.addQueryParam("$expand", expand.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        return this.getJobWithResponse(jobId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (BatchJob)protocolMethodData.toObject(BatchJob.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BatchJob> getJob(String jobId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getJobWithResponse(jobId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (BatchJob)protocolMethodData.toObject(BatchJob.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> updateJob(String jobId, BatchJobUpdateContent job, UpdateBatchJobOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        return this.updateJobWithResponse(jobId, BinaryData.fromObject((Object)job), requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> updateJob(String jobId, BatchJobUpdateContent job) {
        RequestOptions requestOptions = new RequestOptions();
        return this.updateJobWithResponse(jobId, BinaryData.fromObject((Object)job), requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> replaceJob(String jobId, BatchJob job, ReplaceBatchJobOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        return this.replaceJobWithResponse(jobId, BinaryData.fromObject((Object)job), requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> replaceJob(String jobId, BatchJob job) {
        RequestOptions requestOptions = new RequestOptions();
        return this.replaceJobWithResponse(jobId, BinaryData.fromObject((Object)job), requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> disableJob(String jobId, BatchJobDisableContent content, DisableBatchJobOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        return this.disableJobWithResponse(jobId, BinaryData.fromObject((Object)content), requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> disableJob(String jobId, BatchJobDisableContent content) {
        RequestOptions requestOptions = new RequestOptions();
        return this.disableJobWithResponse(jobId, BinaryData.fromObject((Object)content), requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> enableJob(String jobId, EnableBatchJobOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        return this.enableJobWithResponse(jobId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> enableJob(String jobId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.enableJobWithResponse(jobId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> terminateJob(String jobId, TerminateBatchJobOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        BatchJobTerminateContent parameters = options == null ? null : options.getParameters();
        Boolean force = options == null ? null : options.isForce();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (parameters != null) {
            requestOptions.setBody(BinaryData.fromObject((Object)parameters));
        }
        if (force != null) {
            requestOptions.addQueryParam("force", String.valueOf(force), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        return this.terminateJobWithResponse(jobId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> terminateJob(String jobId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.terminateJobWithResponse(jobId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> createJob(BatchJobCreateContent job, CreateBatchJobOptions options) {
        Integer timeOutInSeconds;
        RequestOptions requestOptions = new RequestOptions();
        Integer n = timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        return this.createJobWithResponse(BinaryData.fromObject((Object)job), requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> createJob(BatchJobCreateContent job) {
        RequestOptions requestOptions = new RequestOptions();
        return this.createJobWithResponse(BinaryData.fromObject((Object)job), requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BatchJob> listJobs(ListBatchJobsOptions options) {
        List<String> expand;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        String filter = options == null ? null : options.getFilter();
        List<String> select = options == null ? null : options.getSelect();
        List<String> list = expand = options == null ? null : options.getExpand();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (filter != null) {
            requestOptions.addQueryParam("$filter", filter, false);
        }
        if (select != null) {
            requestOptions.addQueryParam("$select", select.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        if (expand != null) {
            requestOptions.addQueryParam("$expand", expand.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        PagedFlux<BinaryData> pagedFluxResponse = this.listJobs(requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (BatchJob)protocolMethodData.toObject(BatchJob.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BatchJob> listJobs() {
        RequestOptions requestOptions = new RequestOptions();
        PagedFlux<BinaryData> pagedFluxResponse = this.listJobs(requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (BatchJob)protocolMethodData.toObject(BatchJob.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BatchJob> listJobsFromSchedule(String jobScheduleId, ListBatchJobsFromScheduleOptions options) {
        List<String> expand;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        String filter = options == null ? null : options.getFilter();
        List<String> select = options == null ? null : options.getSelect();
        List<String> list = expand = options == null ? null : options.getExpand();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (filter != null) {
            requestOptions.addQueryParam("$filter", filter, false);
        }
        if (select != null) {
            requestOptions.addQueryParam("$select", select.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        if (expand != null) {
            requestOptions.addQueryParam("$expand", expand.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        PagedFlux<BinaryData> pagedFluxResponse = this.listJobsFromSchedule(jobScheduleId, requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (BatchJob)protocolMethodData.toObject(BatchJob.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BatchJob> listJobsFromSchedule(String jobScheduleId) {
        RequestOptions requestOptions = new RequestOptions();
        PagedFlux<BinaryData> pagedFluxResponse = this.listJobsFromSchedule(jobScheduleId, requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (BatchJob)protocolMethodData.toObject(BatchJob.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BatchJobPreparationAndReleaseTaskStatus> listJobPreparationAndReleaseTaskStatus(String jobId, ListBatchJobPreparationAndReleaseTaskStatusOptions options) {
        List<String> select;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        String filter = options == null ? null : options.getFilter();
        List<String> list = select = options == null ? null : options.getSelect();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (filter != null) {
            requestOptions.addQueryParam("$filter", filter, false);
        }
        if (select != null) {
            requestOptions.addQueryParam("$select", select.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        PagedFlux<BinaryData> pagedFluxResponse = this.listJobPreparationAndReleaseTaskStatus(jobId, requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (BatchJobPreparationAndReleaseTaskStatus)protocolMethodData.toObject(BatchJobPreparationAndReleaseTaskStatus.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BatchJobPreparationAndReleaseTaskStatus> listJobPreparationAndReleaseTaskStatus(String jobId) {
        RequestOptions requestOptions = new RequestOptions();
        PagedFlux<BinaryData> pagedFluxResponse = this.listJobPreparationAndReleaseTaskStatus(jobId, requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (BatchJobPreparationAndReleaseTaskStatus)protocolMethodData.toObject(BatchJobPreparationAndReleaseTaskStatus.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BatchTaskCountsResult> getJobTaskCounts(String jobId, GetBatchJobTaskCountsOptions options) {
        Integer timeOutInSeconds;
        RequestOptions requestOptions = new RequestOptions();
        Integer n = timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        return this.getJobTaskCountsWithResponse(jobId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (BatchTaskCountsResult)protocolMethodData.toObject(BatchTaskCountsResult.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BatchTaskCountsResult> getJobTaskCounts(String jobId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getJobTaskCountsWithResponse(jobId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (BatchTaskCountsResult)protocolMethodData.toObject(BatchTaskCountsResult.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> createCertificate(BatchCertificate certificate, CreateBatchCertificateOptions options) {
        Integer timeOutInSeconds;
        RequestOptions requestOptions = new RequestOptions();
        Integer n = timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        return this.createCertificateWithResponse(BinaryData.fromObject((Object)certificate), requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> createCertificate(BatchCertificate certificate) {
        RequestOptions requestOptions = new RequestOptions();
        return this.createCertificateWithResponse(BinaryData.fromObject((Object)certificate), requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BatchCertificate> listCertificates(ListBatchCertificatesOptions options) {
        List<String> select;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        String filter = options == null ? null : options.getFilter();
        List<String> list = select = options == null ? null : options.getSelect();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (filter != null) {
            requestOptions.addQueryParam("$filter", filter, false);
        }
        if (select != null) {
            requestOptions.addQueryParam("$select", select.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        PagedFlux<BinaryData> pagedFluxResponse = this.listCertificates(requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (BatchCertificate)protocolMethodData.toObject(BatchCertificate.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BatchCertificate> listCertificates() {
        RequestOptions requestOptions = new RequestOptions();
        PagedFlux<BinaryData> pagedFluxResponse = this.listCertificates(requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (BatchCertificate)protocolMethodData.toObject(BatchCertificate.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> cancelCertificateDeletion(String thumbprintAlgorithm, String thumbprint, CancelBatchCertificateDeletionOptions options) {
        Integer timeOutInSeconds;
        RequestOptions requestOptions = new RequestOptions();
        Integer n = timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        return this.cancelCertificateDeletionWithResponse(thumbprintAlgorithm, thumbprint, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> cancelCertificateDeletion(String thumbprintAlgorithm, String thumbprint) {
        RequestOptions requestOptions = new RequestOptions();
        return this.cancelCertificateDeletionWithResponse(thumbprintAlgorithm, thumbprint, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteCertificate(String thumbprintAlgorithm, String thumbprint, DeleteBatchCertificateOptions options) {
        Integer timeOutInSeconds;
        RequestOptions requestOptions = new RequestOptions();
        Integer n = timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        return this.deleteCertificateWithResponse(thumbprintAlgorithm, thumbprint, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteCertificate(String thumbprintAlgorithm, String thumbprint) {
        RequestOptions requestOptions = new RequestOptions();
        return this.deleteCertificateWithResponse(thumbprintAlgorithm, thumbprint, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<GetCertificateResponse> getCertificate(String thumbprintAlgorithm, String thumbprint, GetBatchCertificateOptions options) {
        List<String> select;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        List<String> list = select = options == null ? null : options.getSelect();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (select != null) {
            requestOptions.addQueryParam("$select", select.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        return this.getCertificateWithResponse(thumbprintAlgorithm, thumbprint, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (GetCertificateResponse)protocolMethodData.toObject(GetCertificateResponse.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<GetCertificateResponse> getCertificate(String thumbprintAlgorithm, String thumbprint) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getCertificateWithResponse(thumbprintAlgorithm, thumbprint, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (GetCertificateResponse)protocolMethodData.toObject(GetCertificateResponse.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Boolean> jobScheduleExists(String jobScheduleId, BatchJobScheduleExistsOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        return this.jobScheduleExistsWithResponse(jobScheduleId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Boolean> jobScheduleExists(String jobScheduleId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.jobScheduleExistsWithResponse(jobScheduleId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteJobSchedule(String jobScheduleId, DeleteBatchJobScheduleOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        Boolean force = options == null ? null : options.isForce();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (force != null) {
            requestOptions.addQueryParam("force", String.valueOf(force), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        return this.deleteJobScheduleWithResponse(jobScheduleId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteJobSchedule(String jobScheduleId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.deleteJobScheduleWithResponse(jobScheduleId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BatchJobSchedule> getJobSchedule(String jobScheduleId, GetBatchJobScheduleOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        List<String> select = options == null ? null : options.getSelect();
        List<String> expand = options == null ? null : options.getExpand();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (select != null) {
            requestOptions.addQueryParam("$select", select.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        if (expand != null) {
            requestOptions.addQueryParam("$expand", expand.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        return this.getJobScheduleWithResponse(jobScheduleId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (BatchJobSchedule)protocolMethodData.toObject(BatchJobSchedule.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BatchJobSchedule> getJobSchedule(String jobScheduleId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getJobScheduleWithResponse(jobScheduleId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (BatchJobSchedule)protocolMethodData.toObject(BatchJobSchedule.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> updateJobSchedule(String jobScheduleId, BatchJobScheduleUpdateContent jobSchedule, UpdateBatchJobScheduleOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        return this.updateJobScheduleWithResponse(jobScheduleId, BinaryData.fromObject((Object)jobSchedule), requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> updateJobSchedule(String jobScheduleId, BatchJobScheduleUpdateContent jobSchedule) {
        RequestOptions requestOptions = new RequestOptions();
        return this.updateJobScheduleWithResponse(jobScheduleId, BinaryData.fromObject((Object)jobSchedule), requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> replaceJobSchedule(String jobScheduleId, BatchJobSchedule jobSchedule, ReplaceBatchJobScheduleOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        return this.replaceJobScheduleWithResponse(jobScheduleId, BinaryData.fromObject((Object)jobSchedule), requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> replaceJobSchedule(String jobScheduleId, BatchJobSchedule jobSchedule) {
        RequestOptions requestOptions = new RequestOptions();
        return this.replaceJobScheduleWithResponse(jobScheduleId, BinaryData.fromObject((Object)jobSchedule), requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> disableJobSchedule(String jobScheduleId, DisableBatchJobScheduleOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        return this.disableJobScheduleWithResponse(jobScheduleId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> disableJobSchedule(String jobScheduleId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.disableJobScheduleWithResponse(jobScheduleId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> enableJobSchedule(String jobScheduleId, EnableBatchJobScheduleOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        return this.enableJobScheduleWithResponse(jobScheduleId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> enableJobSchedule(String jobScheduleId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.enableJobScheduleWithResponse(jobScheduleId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> terminateJobSchedule(String jobScheduleId, TerminateBatchJobScheduleOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        Boolean force = options == null ? null : options.isForce();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (force != null) {
            requestOptions.addQueryParam("force", String.valueOf(force), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        return this.terminateJobScheduleWithResponse(jobScheduleId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> terminateJobSchedule(String jobScheduleId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.terminateJobScheduleWithResponse(jobScheduleId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> createJobSchedule(BatchJobScheduleCreateContent jobSchedule, CreateBatchJobScheduleOptions options) {
        Integer timeOutInSeconds;
        RequestOptions requestOptions = new RequestOptions();
        Integer n = timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        return this.createJobScheduleWithResponse(BinaryData.fromObject((Object)jobSchedule), requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> createJobSchedule(BatchJobScheduleCreateContent jobSchedule) {
        RequestOptions requestOptions = new RequestOptions();
        return this.createJobScheduleWithResponse(BinaryData.fromObject((Object)jobSchedule), requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BatchJobSchedule> listJobSchedules(ListBatchJobSchedulesOptions options) {
        List<String> expand;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        String filter = options == null ? null : options.getFilter();
        List<String> select = options == null ? null : options.getSelect();
        List<String> list = expand = options == null ? null : options.getExpand();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (filter != null) {
            requestOptions.addQueryParam("$filter", filter, false);
        }
        if (select != null) {
            requestOptions.addQueryParam("$select", select.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        if (expand != null) {
            requestOptions.addQueryParam("$expand", expand.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        PagedFlux<BinaryData> pagedFluxResponse = this.listJobSchedules(requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (BatchJobSchedule)protocolMethodData.toObject(BatchJobSchedule.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BatchJobSchedule> listJobSchedules() {
        RequestOptions requestOptions = new RequestOptions();
        PagedFlux<BinaryData> pagedFluxResponse = this.listJobSchedules(requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (BatchJobSchedule)protocolMethodData.toObject(BatchJobSchedule.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> createTask(String jobId, BatchTaskCreateContent task, CreateBatchTaskOptions options) {
        Integer timeOutInSeconds;
        RequestOptions requestOptions = new RequestOptions();
        Integer n = timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        return this.createTaskWithResponse(jobId, BinaryData.fromObject((Object)task), requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> createTask(String jobId, BatchTaskCreateContent task) {
        RequestOptions requestOptions = new RequestOptions();
        return this.createTaskWithResponse(jobId, BinaryData.fromObject((Object)task), requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BatchTask> listTasks(String jobId, ListBatchTasksOptions options) {
        List<String> expand;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        String filter = options == null ? null : options.getFilter();
        List<String> select = options == null ? null : options.getSelect();
        List<String> list = expand = options == null ? null : options.getExpand();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (filter != null) {
            requestOptions.addQueryParam("$filter", filter, false);
        }
        if (select != null) {
            requestOptions.addQueryParam("$select", select.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        if (expand != null) {
            requestOptions.addQueryParam("$expand", expand.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        PagedFlux<BinaryData> pagedFluxResponse = this.listTasks(jobId, requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (BatchTask)protocolMethodData.toObject(BatchTask.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BatchTask> listTasks(String jobId) {
        RequestOptions requestOptions = new RequestOptions();
        PagedFlux<BinaryData> pagedFluxResponse = this.listTasks(jobId, requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (BatchTask)protocolMethodData.toObject(BatchTask.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BatchTaskAddCollectionResult> createTaskCollection(String jobId, BatchTaskGroup taskCollection, CreateBatchTaskCollectionOptions options) {
        Integer timeOutInSeconds;
        RequestOptions requestOptions = new RequestOptions();
        Integer n = timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        return this.createTaskCollectionWithResponse(jobId, BinaryData.fromObject((Object)taskCollection), requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (BatchTaskAddCollectionResult)protocolMethodData.toObject(BatchTaskAddCollectionResult.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BatchTaskAddCollectionResult> createTaskCollection(String jobId, BatchTaskGroup taskCollection) {
        RequestOptions requestOptions = new RequestOptions();
        return this.createTaskCollectionWithResponse(jobId, BinaryData.fromObject((Object)taskCollection), requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (BatchTaskAddCollectionResult)protocolMethodData.toObject(BatchTaskAddCollectionResult.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteTask(String jobId, String taskId, DeleteBatchTaskOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        return this.deleteTaskWithResponse(jobId, taskId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteTask(String jobId, String taskId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.deleteTaskWithResponse(jobId, taskId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BatchTask> getTask(String jobId, String taskId, GetBatchTaskOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        List<String> select = options == null ? null : options.getSelect();
        List<String> expand = options == null ? null : options.getExpand();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (select != null) {
            requestOptions.addQueryParam("$select", select.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        if (expand != null) {
            requestOptions.addQueryParam("$expand", expand.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        return this.getTaskWithResponse(jobId, taskId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (BatchTask)protocolMethodData.toObject(BatchTask.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BatchTask> getTask(String jobId, String taskId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getTaskWithResponse(jobId, taskId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (BatchTask)protocolMethodData.toObject(BatchTask.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> replaceTask(String jobId, String taskId, BatchTask task, ReplaceBatchTaskOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        return this.replaceTaskWithResponse(jobId, taskId, BinaryData.fromObject((Object)task), requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> replaceTask(String jobId, String taskId, BatchTask task) {
        RequestOptions requestOptions = new RequestOptions();
        return this.replaceTaskWithResponse(jobId, taskId, BinaryData.fromObject((Object)task), requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BatchSubtask> listSubTasks(String jobId, String taskId, ListBatchSubTasksOptions options) {
        List<String> select;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        List<String> list = select = options == null ? null : options.getSelect();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (select != null) {
            requestOptions.addQueryParam("$select", select.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        PagedFlux<BinaryData> pagedFluxResponse = this.listSubTasks(jobId, taskId, requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (BatchSubtask)protocolMethodData.toObject(BatchSubtask.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BatchSubtask> listSubTasks(String jobId, String taskId) {
        RequestOptions requestOptions = new RequestOptions();
        PagedFlux<BinaryData> pagedFluxResponse = this.listSubTasks(jobId, taskId, requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (BatchSubtask)protocolMethodData.toObject(BatchSubtask.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> terminateTask(String jobId, String taskId, TerminateBatchTaskOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        return this.terminateTaskWithResponse(jobId, taskId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> terminateTask(String jobId, String taskId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.terminateTaskWithResponse(jobId, taskId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> reactivateTask(String jobId, String taskId, ReactivateBatchTaskOptions options, RequestConditions requestConditions) {
        String ifNoneMatch;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String string = ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        return this.reactivateTaskWithResponse(jobId, taskId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> reactivateTask(String jobId, String taskId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.reactivateTaskWithResponse(jobId, taskId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteTaskFile(String jobId, String taskId, String filePath, DeleteBatchTaskFileOptions options) {
        Boolean recursive;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        Boolean bl = recursive = options == null ? null : options.isRecursive();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (recursive != null) {
            requestOptions.addQueryParam("recursive", String.valueOf(recursive), false);
        }
        return this.deleteTaskFileWithResponse(jobId, taskId, filePath, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteTaskFile(String jobId, String taskId, String filePath) {
        RequestOptions requestOptions = new RequestOptions();
        return this.deleteTaskFileWithResponse(jobId, taskId, filePath, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BinaryData> getTaskFile(String jobId, String taskId, String filePath, GetBatchTaskFileOptions options) {
        String ocpRange;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = options == null ? null : options.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = options == null ? null : options.getIfUnmodifiedSince();
        String string = ocpRange = options == null ? null : options.getOcpRange();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ocpRange != null) {
            requestOptions.setHeader(HttpHeaderName.fromString((String)"ocp-range"), ocpRange);
        }
        return this.getTaskFileWithResponse(jobId, taskId, filePath, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BinaryData> getTaskFile(String jobId, String taskId, String filePath) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getTaskFileWithResponse(jobId, taskId, filePath, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<FileResponseHeaderProperties> getTaskFileProperties(String jobId, String taskId, String filePath, GetBatchTaskFilePropertiesOptions options) {
        OffsetDateTime ifUnmodifiedSince;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = options == null ? null : options.getIfModifiedSince();
        OffsetDateTime offsetDateTime = ifUnmodifiedSince = options == null ? null : options.getIfUnmodifiedSince();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        return this.getTaskFilePropertiesWithResponse(jobId, taskId, filePath, requestOptions).map(response -> new FileResponseHeaderProperties(response.getHeaders()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<FileResponseHeaderProperties> getTaskFileProperties(String jobId, String taskId, String filePath) {
        return this.getTaskFilePropertiesWithResponse(jobId, taskId, filePath, new RequestOptions()).map(response -> new FileResponseHeaderProperties(response.getHeaders()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BatchNodeFile> listTaskFiles(String jobId, String taskId, ListBatchTaskFilesOptions options) {
        Boolean recursive;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        String filter = options == null ? null : options.getFilter();
        Boolean bl = recursive = options == null ? null : options.isRecursive();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (filter != null) {
            requestOptions.addQueryParam("$filter", filter, false);
        }
        if (recursive != null) {
            requestOptions.addQueryParam("recursive", String.valueOf(recursive), false);
        }
        PagedFlux<BinaryData> pagedFluxResponse = this.listTaskFiles(jobId, taskId, requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (BatchNodeFile)protocolMethodData.toObject(BatchNodeFile.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BatchNodeFile> listTaskFiles(String jobId, String taskId) {
        RequestOptions requestOptions = new RequestOptions();
        PagedFlux<BinaryData> pagedFluxResponse = this.listTaskFiles(jobId, taskId, requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (BatchNodeFile)protocolMethodData.toObject(BatchNodeFile.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> createNodeUser(String poolId, String nodeId, BatchNodeUserCreateContent user, CreateBatchNodeUserOptions options) {
        Integer timeOutInSeconds;
        RequestOptions requestOptions = new RequestOptions();
        Integer n = timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        return this.createNodeUserWithResponse(poolId, nodeId, BinaryData.fromObject((Object)user), requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> createNodeUser(String poolId, String nodeId, BatchNodeUserCreateContent user) {
        RequestOptions requestOptions = new RequestOptions();
        return this.createNodeUserWithResponse(poolId, nodeId, BinaryData.fromObject((Object)user), requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteNodeUser(String poolId, String nodeId, String userName, DeleteBatchNodeUserOptions options) {
        Integer timeOutInSeconds;
        RequestOptions requestOptions = new RequestOptions();
        Integer n = timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        return this.deleteNodeUserWithResponse(poolId, nodeId, userName, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteNodeUser(String poolId, String nodeId, String userName) {
        RequestOptions requestOptions = new RequestOptions();
        return this.deleteNodeUserWithResponse(poolId, nodeId, userName, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> replaceNodeUser(String poolId, String nodeId, String userName, BatchNodeUserUpdateContent content, ReplaceBatchNodeUserOptions options) {
        Integer timeOutInSeconds;
        RequestOptions requestOptions = new RequestOptions();
        Integer n = timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        return this.replaceNodeUserWithResponse(poolId, nodeId, userName, BinaryData.fromObject((Object)content), requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> replaceNodeUser(String poolId, String nodeId, String userName, BatchNodeUserUpdateContent content) {
        RequestOptions requestOptions = new RequestOptions();
        return this.replaceNodeUserWithResponse(poolId, nodeId, userName, BinaryData.fromObject((Object)content), requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BatchNode> getNode(String poolId, String nodeId, GetBatchNodeOptions options) {
        List<String> select;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        List<String> list = select = options == null ? null : options.getSelect();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (select != null) {
            requestOptions.addQueryParam("$select", select.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        return this.getNodeWithResponse(poolId, nodeId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (BatchNode)protocolMethodData.toObject(BatchNode.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BatchNode> getNode(String poolId, String nodeId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getNodeWithResponse(poolId, nodeId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (BatchNode)protocolMethodData.toObject(BatchNode.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> rebootNode(String poolId, String nodeId, RebootBatchNodeOptions options) {
        BatchNodeRebootContent parameters;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        BatchNodeRebootContent batchNodeRebootContent = parameters = options == null ? null : options.getParameters();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (parameters != null) {
            requestOptions.setBody(BinaryData.fromObject((Object)parameters));
        }
        return this.rebootNodeWithResponse(poolId, nodeId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> rebootNode(String poolId, String nodeId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.rebootNodeWithResponse(poolId, nodeId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> startNode(String poolId, String nodeId, StartBatchNodeOptions options) {
        Integer timeOutInSeconds;
        RequestOptions requestOptions = new RequestOptions();
        Integer n = timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        return this.startNodeWithResponse(poolId, nodeId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> startNode(String poolId, String nodeId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.startNodeWithResponse(poolId, nodeId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> reimageNode(String poolId, String nodeId, ReimageBatchNodeOptions options) {
        BatchNodeReimageContent parameters;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        BatchNodeReimageContent batchNodeReimageContent = parameters = options == null ? null : options.getParameters();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (parameters != null) {
            requestOptions.setBody(BinaryData.fromObject((Object)parameters));
        }
        return this.reimageNodeWithResponse(poolId, nodeId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> reimageNode(String poolId, String nodeId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.reimageNodeWithResponse(poolId, nodeId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deallocateNode(String poolId, String nodeId, DeallocateBatchNodeOptions options) {
        BatchNodeDeallocateContent parameters;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        BatchNodeDeallocateContent batchNodeDeallocateContent = parameters = options == null ? null : options.getParameters();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (parameters != null) {
            requestOptions.setBody(BinaryData.fromObject((Object)parameters));
        }
        return this.deallocateNodeWithResponse(poolId, nodeId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deallocateNode(String poolId, String nodeId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.deallocateNodeWithResponse(poolId, nodeId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> disableNodeScheduling(String poolId, String nodeId, DisableBatchNodeSchedulingOptions options) {
        BatchNodeDisableSchedulingContent parameters;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        BatchNodeDisableSchedulingContent batchNodeDisableSchedulingContent = parameters = options == null ? null : options.getParameters();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (parameters != null) {
            requestOptions.setBody(BinaryData.fromObject((Object)parameters));
        }
        return this.disableNodeSchedulingWithResponse(poolId, nodeId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> disableNodeScheduling(String poolId, String nodeId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.disableNodeSchedulingWithResponse(poolId, nodeId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> enableNodeScheduling(String poolId, String nodeId, EnableBatchNodeSchedulingOptions options) {
        Integer timeOutInSeconds;
        RequestOptions requestOptions = new RequestOptions();
        Integer n = timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        return this.enableNodeSchedulingWithResponse(poolId, nodeId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> enableNodeScheduling(String poolId, String nodeId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.enableNodeSchedulingWithResponse(poolId, nodeId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BatchNodeRemoteLoginSettings> getNodeRemoteLoginSettings(String poolId, String nodeId, GetBatchNodeRemoteLoginSettingsOptions options) {
        Integer timeOutInSeconds;
        RequestOptions requestOptions = new RequestOptions();
        Integer n = timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        return this.getNodeRemoteLoginSettingsWithResponse(poolId, nodeId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (BatchNodeRemoteLoginSettings)protocolMethodData.toObject(BatchNodeRemoteLoginSettings.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BatchNodeRemoteLoginSettings> getNodeRemoteLoginSettings(String poolId, String nodeId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getNodeRemoteLoginSettingsWithResponse(poolId, nodeId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (BatchNodeRemoteLoginSettings)protocolMethodData.toObject(BatchNodeRemoteLoginSettings.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<UploadBatchServiceLogsResult> uploadNodeLogs(String poolId, String nodeId, UploadBatchServiceLogsContent content, UploadBatchNodeLogsOptions options) {
        Integer timeOutInSeconds;
        RequestOptions requestOptions = new RequestOptions();
        Integer n = timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        return this.uploadNodeLogsWithResponse(poolId, nodeId, BinaryData.fromObject((Object)content), requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (UploadBatchServiceLogsResult)protocolMethodData.toObject(UploadBatchServiceLogsResult.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<UploadBatchServiceLogsResult> uploadNodeLogs(String poolId, String nodeId, UploadBatchServiceLogsContent content) {
        RequestOptions requestOptions = new RequestOptions();
        return this.uploadNodeLogsWithResponse(poolId, nodeId, BinaryData.fromObject((Object)content), requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (UploadBatchServiceLogsResult)protocolMethodData.toObject(UploadBatchServiceLogsResult.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BatchNode> listNodes(String poolId, ListBatchNodesOptions options) {
        List<String> select;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        String filter = options == null ? null : options.getFilter();
        List<String> list = select = options == null ? null : options.getSelect();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (filter != null) {
            requestOptions.addQueryParam("$filter", filter, false);
        }
        if (select != null) {
            requestOptions.addQueryParam("$select", select.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        PagedFlux<BinaryData> pagedFluxResponse = this.listNodes(poolId, requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (BatchNode)protocolMethodData.toObject(BatchNode.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BatchNode> listNodes(String poolId) {
        RequestOptions requestOptions = new RequestOptions();
        PagedFlux<BinaryData> pagedFluxResponse = this.listNodes(poolId, requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (BatchNode)protocolMethodData.toObject(BatchNode.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BatchNodeVMExtension> getNodeExtension(String poolId, String nodeId, String extensionName, GetBatchNodeExtensionOptions options) {
        List<String> select;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        List<String> list = select = options == null ? null : options.getSelect();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (select != null) {
            requestOptions.addQueryParam("$select", select.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        return this.getNodeExtensionWithResponse(poolId, nodeId, extensionName, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (BatchNodeVMExtension)protocolMethodData.toObject(BatchNodeVMExtension.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BatchNodeVMExtension> getNodeExtension(String poolId, String nodeId, String extensionName) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getNodeExtensionWithResponse(poolId, nodeId, extensionName, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (BatchNodeVMExtension)protocolMethodData.toObject(BatchNodeVMExtension.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BatchNodeVMExtension> listNodeExtensions(String poolId, String nodeId, ListBatchNodeExtensionsOptions options) {
        List<String> select;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        List<String> list = select = options == null ? null : options.getSelect();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (select != null) {
            requestOptions.addQueryParam("$select", select.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        PagedFlux<BinaryData> pagedFluxResponse = this.listNodeExtensions(poolId, nodeId, requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (BatchNodeVMExtension)protocolMethodData.toObject(BatchNodeVMExtension.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BatchNodeVMExtension> listNodeExtensions(String poolId, String nodeId) {
        RequestOptions requestOptions = new RequestOptions();
        PagedFlux<BinaryData> pagedFluxResponse = this.listNodeExtensions(poolId, nodeId, requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (BatchNodeVMExtension)protocolMethodData.toObject(BatchNodeVMExtension.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteNodeFile(String poolId, String nodeId, String filePath, DeleteBatchNodeFileOptions options) {
        Boolean recursive;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        Boolean bl = recursive = options == null ? null : options.isRecursive();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (recursive != null) {
            requestOptions.addQueryParam("recursive", String.valueOf(recursive), false);
        }
        return this.deleteNodeFileWithResponse(poolId, nodeId, filePath, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteNodeFile(String poolId, String nodeId, String filePath) {
        RequestOptions requestOptions = new RequestOptions();
        return this.deleteNodeFileWithResponse(poolId, nodeId, filePath, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BinaryData> getNodeFile(String poolId, String nodeId, String filePath, GetBatchNodeFileOptions options) {
        String ocpRange;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = options == null ? null : options.getIfModifiedSince();
        OffsetDateTime ifUnmodifiedSince = options == null ? null : options.getIfUnmodifiedSince();
        String string = ocpRange = options == null ? null : options.getOcpRange();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ocpRange != null) {
            requestOptions.setHeader(HttpHeaderName.fromString((String)"ocp-range"), ocpRange);
        }
        return this.getNodeFileWithResponse(poolId, nodeId, filePath, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BinaryData> getNodeFile(String poolId, String nodeId, String filePath) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getNodeFileWithResponse(poolId, nodeId, filePath, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<FileResponseHeaderProperties> getNodeFileProperties(String poolId, String nodeId, String filePath, GetBatchNodeFilePropertiesOptions options) {
        OffsetDateTime ifUnmodifiedSince;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        OffsetDateTime ifModifiedSince = options == null ? null : options.getIfModifiedSince();
        OffsetDateTime offsetDateTime = ifUnmodifiedSince = options == null ? null : options.getIfUnmodifiedSince();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        return this.getNodeFilePropertiesWithResponse(poolId, nodeId, filePath, requestOptions).map(response -> new FileResponseHeaderProperties(response.getHeaders()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<FileResponseHeaderProperties> getNodeFileProperties(String poolId, String nodeId, String filePath) {
        return this.getNodeFilePropertiesWithResponse(poolId, nodeId, filePath, new RequestOptions()).map(response -> new FileResponseHeaderProperties(response.getHeaders()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BatchNodeFile> listNodeFiles(String poolId, String nodeId, ListBatchNodeFilesOptions options) {
        Boolean recursive;
        RequestOptions requestOptions = new RequestOptions();
        Integer timeOutInSeconds = options == null ? null : options.getTimeOutInSeconds();
        String filter = options == null ? null : options.getFilter();
        Boolean bl = recursive = options == null ? null : options.isRecursive();
        if (timeOutInSeconds != null) {
            requestOptions.addQueryParam("timeOut", String.valueOf(timeOutInSeconds), false);
        }
        if (filter != null) {
            requestOptions.addQueryParam("$filter", filter, false);
        }
        if (recursive != null) {
            requestOptions.addQueryParam("recursive", String.valueOf(recursive), false);
        }
        PagedFlux<BinaryData> pagedFluxResponse = this.listNodeFiles(poolId, nodeId, requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (BatchNodeFile)protocolMethodData.toObject(BatchNodeFile.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BatchNodeFile> listNodeFiles(String poolId, String nodeId) {
        RequestOptions requestOptions = new RequestOptions();
        PagedFlux<BinaryData> pagedFluxResponse = this.listNodeFiles(poolId, nodeId, requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (BatchNodeFile)protocolMethodData.toObject(BatchNodeFile.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }
}

