/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.phonenumbers.models;

import com.azure.communication.phonenumbers.models.PhoneNumberAssignmentType;
import com.azure.communication.phonenumbers.models.PhoneNumberCapabilities;
import com.azure.communication.phonenumbers.models.PhoneNumberCost;
import com.azure.communication.phonenumbers.models.PhoneNumberType;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class PurchasedPhoneNumber
implements JsonSerializable<PurchasedPhoneNumber> {
    private String id;
    private String phoneNumber;
    private String countryCode;
    private PhoneNumberType phoneNumberType;
    private PhoneNumberCapabilities capabilities;
    private PhoneNumberAssignmentType assignmentType;
    private OffsetDateTime purchaseDate;
    private PhoneNumberCost cost;

    public String getId() {
        return this.id;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public PhoneNumberType getPhoneNumberType() {
        return this.phoneNumberType;
    }

    public PhoneNumberCapabilities getCapabilities() {
        return this.capabilities;
    }

    public PhoneNumberAssignmentType getAssignmentType() {
        return this.assignmentType;
    }

    public OffsetDateTime getPurchaseDate() {
        return this.purchaseDate;
    }

    public PhoneNumberCost getCost() {
        return this.cost;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static PurchasedPhoneNumber fromJson(JsonReader jsonReader) throws IOException {
        return (PurchasedPhoneNumber)jsonReader.readObject(reader -> {
            PurchasedPhoneNumber deserializedPurchasedPhoneNumber = new PurchasedPhoneNumber();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedPurchasedPhoneNumber.id = reader.getString();
                    continue;
                }
                if ("phoneNumber".equals(fieldName)) {
                    deserializedPurchasedPhoneNumber.phoneNumber = reader.getString();
                    continue;
                }
                if ("countryCode".equals(fieldName)) {
                    deserializedPurchasedPhoneNumber.countryCode = reader.getString();
                    continue;
                }
                if ("phoneNumberType".equals(fieldName)) {
                    deserializedPurchasedPhoneNumber.phoneNumberType = PhoneNumberType.fromString(reader.getString());
                    continue;
                }
                if ("capabilities".equals(fieldName)) {
                    deserializedPurchasedPhoneNumber.capabilities = PhoneNumberCapabilities.fromJson(reader);
                    continue;
                }
                if ("assignmentType".equals(fieldName)) {
                    deserializedPurchasedPhoneNumber.assignmentType = PhoneNumberAssignmentType.fromString(reader.getString());
                    continue;
                }
                if ("purchaseDate".equals(fieldName)) {
                    deserializedPurchasedPhoneNumber.purchaseDate = (OffsetDateTime)reader.getNullable(nonNullReader -> OffsetDateTime.parse(nonNullReader.getString()));
                    continue;
                }
                if ("cost".equals(fieldName)) {
                    deserializedPurchasedPhoneNumber.cost = PhoneNumberCost.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPurchasedPhoneNumber;
        });
    }
}

