/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.phonenumbers.models;

import com.azure.communication.phonenumbers.models.PhoneNumberAssignmentType;
import com.azure.communication.phonenumbers.models.PhoneNumberCapabilities;
import com.azure.communication.phonenumbers.models.PhoneNumberCost;
import com.azure.communication.phonenumbers.models.PhoneNumberType;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class PhoneNumberSearchResult
implements JsonSerializable<PhoneNumberSearchResult> {
    private String searchId;
    private List<String> phoneNumbers;
    private PhoneNumberType phoneNumberType;
    private PhoneNumberAssignmentType assignmentType;
    private PhoneNumberCapabilities capabilities;
    private PhoneNumberCost cost;
    private OffsetDateTime searchExpiresBy;

    public String getSearchId() {
        return this.searchId;
    }

    public List<String> getPhoneNumbers() {
        return this.phoneNumbers;
    }

    public PhoneNumberType getPhoneNumberType() {
        return this.phoneNumberType;
    }

    public PhoneNumberAssignmentType getAssignmentType() {
        return this.assignmentType;
    }

    public PhoneNumberCapabilities getCapabilities() {
        return this.capabilities;
    }

    public PhoneNumberCost getCost() {
        return this.cost;
    }

    public OffsetDateTime getSearchExpiresBy() {
        return this.searchExpiresBy;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static PhoneNumberSearchResult fromJson(JsonReader jsonReader) throws IOException {
        return (PhoneNumberSearchResult)jsonReader.readObject(reader -> {
            PhoneNumberSearchResult deserializedPhoneNumberSearchResult = new PhoneNumberSearchResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("searchId".equals(fieldName)) {
                    deserializedPhoneNumberSearchResult.searchId = reader.getString();
                    continue;
                }
                if ("phoneNumbers".equals(fieldName)) {
                    List phoneNumbers;
                    deserializedPhoneNumberSearchResult.phoneNumbers = phoneNumbers = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("phoneNumberType".equals(fieldName)) {
                    deserializedPhoneNumberSearchResult.phoneNumberType = PhoneNumberType.fromString(reader.getString());
                    continue;
                }
                if ("assignmentType".equals(fieldName)) {
                    deserializedPhoneNumberSearchResult.assignmentType = PhoneNumberAssignmentType.fromString(reader.getString());
                    continue;
                }
                if ("capabilities".equals(fieldName)) {
                    deserializedPhoneNumberSearchResult.capabilities = PhoneNumberCapabilities.fromJson(reader);
                    continue;
                }
                if ("cost".equals(fieldName)) {
                    deserializedPhoneNumberSearchResult.cost = PhoneNumberCost.fromJson(reader);
                    continue;
                }
                if ("searchExpiresBy".equals(fieldName)) {
                    deserializedPhoneNumberSearchResult.searchExpiresBy = (OffsetDateTime)reader.getNullable(nonNullReader -> OffsetDateTime.parse(nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPhoneNumberSearchResult;
        });
    }
}

