/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.phonenumbers.implementation.models;

import com.azure.communication.phonenumbers.implementation.models.CommunicationError;
import com.azure.communication.phonenumbers.models.PhoneNumberOperationStatus;
import com.azure.communication.phonenumbers.models.PhoneNumberOperationType;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class PhoneNumberRawOperation
implements JsonSerializable<PhoneNumberRawOperation> {
    private PhoneNumberOperationType operationType;
    private PhoneNumberOperationStatus status;
    private String resourceLocation;
    private OffsetDateTime createdDateTime;
    private CommunicationError error;
    private String id;
    private OffsetDateTime lastActionDateTime;

    public PhoneNumberOperationType getOperationType() {
        return this.operationType;
    }

    public PhoneNumberRawOperation setOperationType(PhoneNumberOperationType operationType) {
        this.operationType = operationType;
        return this;
    }

    public PhoneNumberOperationStatus getStatus() {
        return this.status;
    }

    public PhoneNumberRawOperation setStatus(PhoneNumberOperationStatus status) {
        this.status = status;
        return this;
    }

    public String getResourceLocation() {
        return this.resourceLocation;
    }

    public PhoneNumberRawOperation setResourceLocation(String resourceLocation) {
        this.resourceLocation = resourceLocation;
        return this;
    }

    public OffsetDateTime getCreatedDateTime() {
        return this.createdDateTime;
    }

    public PhoneNumberRawOperation setCreatedDateTime(OffsetDateTime createdDateTime) {
        this.createdDateTime = createdDateTime;
        return this;
    }

    public CommunicationError getError() {
        return this.error;
    }

    public PhoneNumberRawOperation setError(CommunicationError error) {
        this.error = error;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public PhoneNumberRawOperation setId(String id) {
        this.id = id;
        return this;
    }

    public OffsetDateTime getLastActionDateTime() {
        return this.lastActionDateTime;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("operationType", this.operationType == null ? null : this.operationType.toString());
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeStringField("createdDateTime", this.createdDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdDateTime));
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("resourceLocation", this.resourceLocation);
        jsonWriter.writeJsonField("error", (JsonSerializable)this.error);
        return jsonWriter.writeEndObject();
    }

    public static PhoneNumberRawOperation fromJson(JsonReader jsonReader) throws IOException {
        return (PhoneNumberRawOperation)jsonReader.readObject(reader -> {
            PhoneNumberRawOperation deserializedPhoneNumberRawOperation = new PhoneNumberRawOperation();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("operationType".equals(fieldName)) {
                    deserializedPhoneNumberRawOperation.operationType = PhoneNumberOperationType.fromString(reader.getString());
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedPhoneNumberRawOperation.status = PhoneNumberOperationStatus.fromString(reader.getString());
                    continue;
                }
                if ("createdDateTime".equals(fieldName)) {
                    deserializedPhoneNumberRawOperation.createdDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> OffsetDateTime.parse(nonNullReader.getString()));
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedPhoneNumberRawOperation.id = reader.getString();
                    continue;
                }
                if ("resourceLocation".equals(fieldName)) {
                    deserializedPhoneNumberRawOperation.resourceLocation = reader.getString();
                    continue;
                }
                if ("error".equals(fieldName)) {
                    deserializedPhoneNumberRawOperation.error = CommunicationError.fromJson(reader);
                    continue;
                }
                if ("lastActionDateTime".equals(fieldName)) {
                    deserializedPhoneNumberRawOperation.lastActionDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> OffsetDateTime.parse(nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPhoneNumberRawOperation;
        });
    }
}

