/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.email.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class EmailAddress
implements JsonSerializable<EmailAddress> {
    private final String address;
    private String displayName;

    public EmailAddress(String address) {
        this.address = address;
    }

    public String getAddress() {
        return this.address;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public EmailAddress setDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("address", this.address);
        jsonWriter.writeStringField("displayName", this.displayName);
        return jsonWriter.writeEndObject();
    }

    public static EmailAddress fromJson(JsonReader jsonReader) throws IOException {
        return (EmailAddress)jsonReader.readObject(reader -> {
            boolean addressFound = false;
            String address = null;
            String displayName = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("address".equals(fieldName)) {
                    address = reader.getString();
                    addressFound = true;
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    displayName = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            if (addressFound) {
                EmailAddress deserializedEmailAddress = new EmailAddress(address);
                deserializedEmailAddress.displayName = displayName;
                return deserializedEmailAddress;
            }
            throw new IllegalStateException("Missing required property: address");
        });
    }
}

