/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.email.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class EmailContent
implements JsonSerializable<EmailContent> {
    private final String subject;
    private String plainText;
    private String html;

    public EmailContent(String subject) {
        this.subject = subject;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getPlainText() {
        return this.plainText;
    }

    public EmailContent setPlainText(String plainText) {
        this.plainText = plainText;
        return this;
    }

    public String getHtml() {
        return this.html;
    }

    public EmailContent setHtml(String html) {
        this.html = html;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("subject", this.subject);
        jsonWriter.writeStringField("plainText", this.plainText);
        jsonWriter.writeStringField("html", this.html);
        return jsonWriter.writeEndObject();
    }

    public static EmailContent fromJson(JsonReader jsonReader) throws IOException {
        return (EmailContent)jsonReader.readObject(reader -> {
            boolean subjectFound = false;
            String subject = null;
            String plainText = null;
            String html = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("subject".equals(fieldName)) {
                    subject = reader.getString();
                    subjectFound = true;
                    continue;
                }
                if ("plainText".equals(fieldName)) {
                    plainText = reader.getString();
                    continue;
                }
                if ("html".equals(fieldName)) {
                    html = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            if (subjectFound) {
                EmailContent deserializedEmailContent = new EmailContent(subject);
                deserializedEmailContent.plainText = plainText;
                deserializedEmailContent.html = html;
                return deserializedEmailContent;
            }
            throw new IllegalStateException("Missing required property: subject");
        });
    }
}

