/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.email.models;

import com.azure.communication.email.models.EmailAddress;
import com.azure.communication.email.models.EmailAttachment;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public final class EmailMessage {
    private Map<String, String> headers;
    private String senderAddress;
    private String subject;
    private String bodyPlainText;
    private String bodyHtml;
    private List<EmailAddress> toRecipients;
    private List<EmailAddress> ccRecipients;
    private List<EmailAddress> bccRecipients;
    private List<EmailAttachment> attachments;
    private List<EmailAddress> replyTo;
    private Boolean userEngagementTrackingDisabled;

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public EmailMessage setHeaders(Map<String, String> headers) {
        this.headers = headers;
        return this;
    }

    public String getSenderAddress() {
        return this.senderAddress;
    }

    public EmailMessage setSenderAddress(String senderAddress) {
        this.senderAddress = senderAddress;
        return this;
    }

    public String getSubject() {
        return this.subject;
    }

    public EmailMessage setSubject(String subject) {
        this.subject = subject;
        return this;
    }

    public String getBodyPlainText() {
        return this.bodyPlainText;
    }

    public EmailMessage setBodyPlainText(String bodyPlainText) {
        this.bodyPlainText = bodyPlainText;
        return this;
    }

    public String getBodyHtml() {
        return this.bodyHtml;
    }

    public EmailMessage setBodyHtml(String bodyHtml) {
        this.bodyHtml = bodyHtml;
        return this;
    }

    public List<EmailAddress> getToRecipients() {
        return this.toRecipients;
    }

    public EmailMessage setToRecipients(List<EmailAddress> toRecipients) {
        this.toRecipients = toRecipients;
        return this;
    }

    public EmailMessage setToRecipients(EmailAddress ... toRecipients) {
        this.toRecipients = Arrays.asList(toRecipients);
        return this;
    }

    public EmailMessage setToRecipients(String ... toRecipientAddresses) {
        ArrayList<EmailAddress> toRecipients = new ArrayList<EmailAddress>();
        for (String toRecipientAddress : toRecipientAddresses) {
            toRecipients.add(new EmailAddress(toRecipientAddress));
        }
        this.toRecipients = toRecipients;
        return this;
    }

    public List<EmailAddress> getCcRecipients() {
        return this.ccRecipients;
    }

    public EmailMessage setCcRecipients(List<EmailAddress> ccRecipients) {
        this.ccRecipients = ccRecipients;
        return this;
    }

    public EmailMessage setCcRecipients(EmailAddress ... ccRecipients) {
        this.ccRecipients = Arrays.asList(ccRecipients);
        return this;
    }

    public EmailMessage setCcRecipients(String ... ccRecipientAddresses) {
        ArrayList<EmailAddress> ccRecipients = new ArrayList<EmailAddress>();
        for (String ccRecipientAddress : ccRecipientAddresses) {
            ccRecipients.add(new EmailAddress(ccRecipientAddress));
        }
        this.ccRecipients = ccRecipients;
        return this;
    }

    public List<EmailAddress> getBccRecipients() {
        return this.bccRecipients;
    }

    public EmailMessage setBccRecipients(List<EmailAddress> bccRecipients) {
        this.bccRecipients = bccRecipients;
        return this;
    }

    public EmailMessage setBccRecipients(EmailAddress ... bccRecipients) {
        this.bccRecipients = Arrays.asList(bccRecipients);
        return this;
    }

    public EmailMessage setBccRecipients(String ... bccRecipientAddresses) {
        ArrayList<EmailAddress> bccRecipients = new ArrayList<EmailAddress>();
        for (String bccRecipientAddress : bccRecipientAddresses) {
            bccRecipients.add(new EmailAddress(bccRecipientAddress));
        }
        this.bccRecipients = bccRecipients;
        return this;
    }

    public List<EmailAttachment> getAttachments() {
        return this.attachments;
    }

    public EmailMessage setAttachments(List<EmailAttachment> attachments) {
        this.attachments = attachments;
        return this;
    }

    public EmailMessage setAttachments(EmailAttachment ... attachments) {
        this.attachments = Arrays.asList(attachments);
        return this;
    }

    public List<EmailAddress> getReplyTo() {
        return this.replyTo;
    }

    public EmailMessage setReplyTo(List<EmailAddress> replyTo) {
        this.replyTo = replyTo;
        return this;
    }

    public EmailMessage setReplyTo(EmailAddress ... replyTo) {
        this.replyTo = Arrays.asList(replyTo);
        return this;
    }

    public Boolean isUserEngagementTrackingDisabled() {
        return this.userEngagementTrackingDisabled;
    }

    public EmailMessage setUserEngagementTrackingDisabled(Boolean userEngagementTrackingDisabled) {
        this.userEngagementTrackingDisabled = userEngagementTrackingDisabled;
        return this;
    }
}

