/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.email.implementation.models;

import com.azure.core.util.BinaryData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;

public final class EmailAttachment
implements JsonSerializable<EmailAttachment> {
    private final String name;
    private final String contentType;
    private final BinaryData contentInBase64;
    private String contentId;

    public EmailAttachment(String name, String contentType, BinaryData contentInBase64) {
        this.name = name;
        this.contentType = contentType;
        this.contentInBase64 = contentInBase64;
    }

    public String getName() {
        return this.name;
    }

    public String getContentType() {
        return this.contentType;
    }

    @Deprecated
    public BinaryData getContent() {
        return this.contentInBase64;
    }

    public BinaryData getContentInBase64() {
        return this.contentInBase64;
    }

    public String getContentId() {
        return this.contentId;
    }

    public EmailAttachment setContentId(String contentId) {
        this.contentId = contentId;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("contentType", this.contentType);
        jsonWriter.writeStringField("contentInBase64", this.contentInBase64.toString());
        jsonWriter.writeStringField("contentId", this.contentId);
        return jsonWriter.writeEndObject();
    }

    public static EmailAttachment fromJson(JsonReader jsonReader) throws IOException {
        return (EmailAttachment)jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            boolean contentTypeFound = false;
            String contentType = null;
            boolean contentInBase64Found = false;
            BinaryData contentInBase64 = null;
            String contentId = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                    continue;
                }
                if ("contentType".equals(fieldName)) {
                    contentType = reader.getString();
                    contentTypeFound = true;
                    continue;
                }
                if ("contentInBase64".equals(fieldName)) {
                    contentInBase64 = BinaryData.fromString((String)reader.getBinary().toString());
                    contentInBase64Found = true;
                    continue;
                }
                if ("contentId".equals(fieldName)) {
                    contentId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            if (nameFound && contentTypeFound && contentInBase64Found) {
                EmailAttachment deserializedEmailAttachment = new EmailAttachment(name, contentType, contentInBase64);
                deserializedEmailAttachment.contentId = contentId;
                return deserializedEmailAttachment;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!nameFound) {
                missingProperties.add("name");
            }
            if (!contentTypeFound) {
                missingProperties.add("contentType");
            }
            if (!contentInBase64Found) {
                missingProperties.add("contentInBase64");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

