/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.common;

import com.azure.communication.common.EntraCommunicationTokenCredentialOptions;
import com.azure.communication.common.EntraCommunicationTokenUtils;
import com.azure.communication.common.implementation.EntraTokenGuardPolicy;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.BearerTokenAuthenticationPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import reactor.core.publisher.Mono;

final class EntraTokenCredential
implements AutoCloseable {
    private final ClientLogger logger = new ClientLogger(EntraTokenCredential.class);
    private final String resourceEndpoint;
    private final List<String> scopes;
    private HttpPipeline pipeline;

    EntraTokenCredential(EntraCommunicationTokenCredentialOptions entraTokenOptions) {
        this(entraTokenOptions, null);
    }

    EntraTokenCredential(EntraCommunicationTokenCredentialOptions entraTokenOptions, HttpClient httpClient) {
        this.resourceEndpoint = entraTokenOptions.getResourceEndpoint();
        this.scopes = new ArrayList<String>(entraTokenOptions.getScopes());
        this.pipeline = this.createPipelineFromOptions(entraTokenOptions, httpClient);
        this.exchangeEntraToken().subscribe();
    }

    private HttpPipeline createPipelineFromOptions(EntraCommunicationTokenCredentialOptions entraTokenOptions, HttpClient httpClient) {
        BearerTokenAuthenticationPolicy authPolicy = new BearerTokenAuthenticationPolicy(entraTokenOptions.getTokenCredential(), this.scopes.toArray(new String[0]));
        EntraTokenGuardPolicy guardPolicy = new EntraTokenGuardPolicy();
        RetryPolicy retryPolicy = new RetryPolicy();
        HttpClient clientToUse = httpClient != null ? httpClient : HttpClient.createDefault();
        return new HttpPipelineBuilder().httpClient(clientToUse).policies(new HttpPipelinePolicy[]{authPolicy, guardPolicy, retryPolicy}).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Mono<String> exchangeEntraToken() {
        HttpRequest request = this.createRequest();
        EntraTokenCredential entraTokenCredential = this;
        synchronized (entraTokenCredential) {
            return this.pipeline.send(request).flatMap(response -> {
                if (response.getStatusCode() == 200) {
                    return this.parseAccessTokenFromResponse((HttpResponse)response);
                }
                return response.getBodyAsString().defaultIfEmpty((Object)"").flatMap(body -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new HttpResponseException("Failed to exchange Entra token : " + body, response)));
            });
        }
    }

    @Override
    public void close() {
        this.pipeline = null;
    }

    private HttpRequest createRequest() {
        String url = this.createRequestUrl();
        HttpRequest request = new HttpRequest(HttpMethod.POST, url);
        request.setHeader(HttpHeaderName.ACCEPT, "application/json");
        request.setHeader(HttpHeaderName.CONTENT_TYPE, "application/json");
        request.setBody("{}".getBytes(StandardCharsets.UTF_8));
        return request;
    }

    private String createRequestUrl() {
        String[] endpointAndVersion = this.determineEndpointAndApiVersion();
        String endpoint = endpointAndVersion[0];
        String apiVersion = endpointAndVersion[1];
        return this.resourceEndpoint + endpoint + "?api-version=" + apiVersion;
    }

    private String[] determineEndpointAndApiVersion() {
        if (EntraCommunicationTokenUtils.allScopesStartWith(this.scopes, "https://auth.msft.communication.azure.com/")) {
            return new String[]{"/access/teamsExtension/:exchangeAccessToken", "2025-06-30"};
        }
        if (EntraCommunicationTokenUtils.allScopesStartWith(this.scopes, "https://communication.azure.com/clients/")) {
            return new String[]{"/access/entra/:exchangeAccessToken", "2025-03-02-preview"};
        }
        throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Scopes validation failed. Ensure all scopes start with either https://auth.msft.communication.azure.com/ or https://communication.azure.com/clients/"));
    }

    private Mono<String> parseAccessTokenFromResponse(HttpResponse response) {
        return response.getBodyAsString(StandardCharsets.UTF_8).flatMap(body -> {
            try {
                JsonNode root = new ObjectMapper().readTree(body);
                JsonNode accessTokenNode = root.get("accessToken");
                String token = accessTokenNode.get("token").asText();
                return Mono.just((Object)token);
            }
            catch (IOException | RuntimeException ex) {
                return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new HttpResponseException("Failed to parse the response : " + body, response));
            }
        });
    }
}

