/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.chat.models;

import com.azure.communication.chat.models.ChatRetentionPolicy;
import com.azure.communication.chat.models.RetentionPolicyKind;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ThreadCreationDateRetentionPolicy
extends ChatRetentionPolicy {
    private final RetentionPolicyKind kind = RetentionPolicyKind.THREAD_CREATION_DATE;
    private int deleteThreadAfterDays;

    public ThreadCreationDateRetentionPolicy(int deleteThreadAfterDays) {
        this.deleteThreadAfterDays = deleteThreadAfterDays;
    }

    @Override
    public RetentionPolicyKind getKind() {
        return this.kind;
    }

    public int getDeleteThreadAfterDays() {
        return this.deleteThreadAfterDays;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("deleteThreadAfterDays", this.deleteThreadAfterDays);
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        return jsonWriter.writeEndObject();
    }

    public static ThreadCreationDateRetentionPolicy fromJson(JsonReader jsonReader) throws IOException {
        return (ThreadCreationDateRetentionPolicy)jsonReader.readObject(reader -> {
            int deleteThreadAfterDays = 0;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("deleteThreadAfterDays".equals(fieldName)) {
                    deleteThreadAfterDays = reader.getInt();
                    continue;
                }
                reader.skipChildren();
            }
            return new ThreadCreationDateRetentionPolicy(deleteThreadAfterDays);
        });
    }
}

