/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.chat.models;

import com.azure.communication.chat.models.ChatMessageType;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

public final class SendChatMessageOptions
implements JsonSerializable<SendChatMessageOptions> {
    private String content;
    private String senderDisplayName;
    private ChatMessageType type;
    private Map<String, String> metadata;

    public String getContent() {
        return this.content;
    }

    public SendChatMessageOptions setContent(String content) {
        this.content = content;
        return this;
    }

    public String getSenderDisplayName() {
        return this.senderDisplayName;
    }

    public SendChatMessageOptions setSenderDisplayName(String senderDisplayName) {
        this.senderDisplayName = senderDisplayName;
        return this;
    }

    public ChatMessageType getType() {
        return this.type;
    }

    public SendChatMessageOptions setType(ChatMessageType type) {
        this.type = type;
        return this;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public SendChatMessageOptions setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("content", this.content);
        jsonWriter.writeStringField("senderDisplayName", this.senderDisplayName);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeMapField("metadata", this.metadata, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static SendChatMessageOptions fromJson(JsonReader jsonReader) throws IOException {
        return (SendChatMessageOptions)jsonReader.readObject(reader -> {
            SendChatMessageOptions deserializedSendChatMessageOptions = new SendChatMessageOptions();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("content".equals(fieldName)) {
                    deserializedSendChatMessageOptions.content = reader.getString();
                    continue;
                }
                if ("senderDisplayName".equals(fieldName)) {
                    deserializedSendChatMessageOptions.senderDisplayName = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSendChatMessageOptions.type = ChatMessageType.fromString(reader.getString());
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    Map metadata;
                    deserializedSendChatMessageOptions.metadata = metadata = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSendChatMessageOptions;
        });
    }
}

