/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.chat.models;

import com.azure.communication.chat.models.ChatError;
import com.azure.communication.chat.models.ChatThreadProperties;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class CreateChatThreadResult
implements JsonSerializable<CreateChatThreadResult> {
    private ChatThreadProperties chatThreadProperties;
    private List<ChatError> invalidParticipants;

    public CreateChatThreadResult(ChatThreadProperties chatThreadProperties, List<ChatError> invalidParticipants) {
        this.chatThreadProperties = chatThreadProperties;
        this.invalidParticipants = invalidParticipants;
    }

    public ChatThreadProperties getChatThread() {
        return this.chatThreadProperties;
    }

    public List<ChatError> getInvalidParticipants() {
        return this.invalidParticipants;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("chatThread", (JsonSerializable)this.chatThreadProperties);
        return jsonWriter.writeEndObject();
    }

    public static CreateChatThreadResult fromJson(JsonReader jsonReader) throws IOException {
        return (CreateChatThreadResult)jsonReader.readObject(reader -> {
            ChatThreadProperties chatThreadProperties = null;
            List invalidParticipants = null;
            while (jsonReader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("chatThread".equals(fieldName)) {
                    chatThreadProperties = ChatThreadProperties.fromJson(reader);
                    continue;
                }
                if ("invalidParticipants".equals(fieldName)) {
                    invalidParticipants = reader.readArray(ChatError::fromJson);
                    continue;
                }
                reader.skipChildren();
            }
            return new CreateChatThreadResult(chatThreadProperties, invalidParticipants);
        });
    }
}

