/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.chat.models;

import com.azure.communication.chat.implementation.converters.CommunicationIdentifierConverter;
import com.azure.communication.chat.implementation.models.CommunicationIdentifierModel;
import com.azure.communication.common.CommunicationIdentifier;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class ChatMessageReadReceipt
implements JsonSerializable<ChatMessageReadReceipt> {
    private CommunicationIdentifier sender;
    private String chatMessageId;
    private OffsetDateTime readOn;

    public CommunicationIdentifier getSender() {
        return this.sender;
    }

    public ChatMessageReadReceipt setSender(CommunicationIdentifier sender) {
        this.sender = sender;
        return this;
    }

    public String getChatMessageId() {
        return this.chatMessageId;
    }

    public ChatMessageReadReceipt setChatMessageId(String chatMessageId) {
        this.chatMessageId = chatMessageId;
        return this;
    }

    public OffsetDateTime getReadOn() {
        return this.readOn;
    }

    public ChatMessageReadReceipt setReadOn(OffsetDateTime readOn) {
        this.readOn = readOn;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static ChatMessageReadReceipt fromJson(JsonReader jsonReader) throws IOException {
        return (ChatMessageReadReceipt)jsonReader.readObject(reader -> {
            ChatMessageReadReceipt receipt = new ChatMessageReadReceipt();
            while (jsonReader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("senderCommunicationIdentifier".equals(fieldName)) {
                    CommunicationIdentifierModel identifier = (CommunicationIdentifierModel)reader.readObject(CommunicationIdentifierModel::fromJson);
                    receipt.setSender(CommunicationIdentifierConverter.convert(identifier));
                    continue;
                }
                if ("chatMessageId".equals(fieldName)) {
                    receipt.setChatMessageId(reader.getString());
                    continue;
                }
                if ("readOn".equals(fieldName)) {
                    String value = reader.getString();
                    if (CoreUtils.isNullOrEmpty((CharSequence)value)) continue;
                    receipt.setReadOn(OffsetDateTime.parse(value));
                    continue;
                }
                reader.skipChildren();
            }
            return receipt;
        });
    }
}

