/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.chat.models;

import com.azure.communication.chat.implementation.converters.CommunicationIdentifierConverter;
import com.azure.communication.chat.implementation.models.CommunicationIdentifierModel;
import com.azure.communication.chat.models.ChatAttachment;
import com.azure.communication.chat.models.ChatParticipant;
import com.azure.communication.common.CommunicationIdentifier;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class ChatMessageContent
implements JsonSerializable<ChatMessageContent> {
    private final String message;
    private final String topic;
    private final Iterable<ChatParticipant> participants;
    private Iterable<ChatAttachment> attachments;
    private final CommunicationIdentifier initiator;

    public ChatMessageContent(String message, String topic, Iterable<ChatParticipant> participants, CommunicationIdentifier initiator) {
        this.message = message;
        this.topic = topic;
        this.participants = participants;
        this.initiator = initiator;
    }

    public String getMessage() {
        return this.message;
    }

    public String getTopic() {
        return this.topic;
    }

    public Iterable<ChatParticipant> getParticipants() {
        return this.participants;
    }

    public Iterable<ChatAttachment> getAttachments() {
        return this.attachments;
    }

    public ChatMessageContent setAttachments(Iterable<ChatAttachment> attachments) {
        this.attachments = attachments;
        return this;
    }

    public CommunicationIdentifier getInitiator() {
        return this.initiator;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("message", this.message);
        jsonWriter.writeStringField("topic", this.topic);
        jsonWriter.writeArrayField("participants", this.participants, (writer, participant) -> participant.toJson((JsonWriter)writer));
        jsonWriter.writeArrayField("attachments", this.attachments, (writer, attachment) -> attachment.toJson((JsonWriter)writer));
        return jsonWriter.writeEndObject();
    }

    public static ChatMessageContent fromJson(JsonReader jsonReader) throws IOException {
        return (ChatMessageContent)jsonReader.readObject(reader -> {
            String message = null;
            String topic = null;
            List participants = null;
            List attachments = null;
            CommunicationIdentifier initiator = null;
            while (jsonReader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("message".equals(fieldName)) {
                    message = reader.getString();
                    continue;
                }
                if ("topic".equals(fieldName)) {
                    topic = reader.getString();
                    continue;
                }
                if ("participants".equals(fieldName)) {
                    participants = reader.readArray(ChatParticipant::fromJson);
                    continue;
                }
                if ("attachments".equals(fieldName)) {
                    attachments = reader.readArray(ChatAttachment::fromJson);
                    continue;
                }
                if ("initiatorCommunicationIdentifier".equals(fieldName)) {
                    CommunicationIdentifierModel identifier = (CommunicationIdentifierModel)reader.readObject(CommunicationIdentifierModel::fromJson);
                    initiator = CommunicationIdentifierConverter.convert(identifier);
                    continue;
                }
                reader.skipChildren();
            }
            return new ChatMessageContent(message, topic, participants, initiator).setAttachments(attachments);
        });
    }
}

