/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.chat.models;

import com.azure.communication.chat.implementation.converters.CommunicationIdentifierConverter;
import com.azure.communication.chat.implementation.models.CommunicationIdentifierModel;
import com.azure.communication.chat.models.ChatMessageContent;
import com.azure.communication.chat.models.ChatMessageType;
import com.azure.communication.common.CommunicationIdentifier;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Map;

public final class ChatMessage
implements JsonSerializable<ChatMessage> {
    private String id;
    private ChatMessageType type;
    private String version;
    private ChatMessageContent content;
    private String senderDisplayName;
    private OffsetDateTime createdOn;
    private CommunicationIdentifier sender;
    private OffsetDateTime deletedOn;
    private OffsetDateTime editedOn;
    private Map<String, String> metadata;

    public String getId() {
        return this.id;
    }

    public ChatMessage setId(String id) {
        this.id = id;
        return this;
    }

    public ChatMessageType getType() {
        return this.type;
    }

    public ChatMessage setType(ChatMessageType type) {
        this.type = type;
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public ChatMessage setVersion(String version) {
        this.version = version;
        return this;
    }

    public ChatMessageContent getContent() {
        return this.content;
    }

    public ChatMessage setContent(ChatMessageContent content) {
        this.content = content;
        return this;
    }

    public String getSenderDisplayName() {
        return this.senderDisplayName;
    }

    public ChatMessage setSenderDisplayName(String senderDisplayName) {
        this.senderDisplayName = senderDisplayName;
        return this;
    }

    public OffsetDateTime getCreatedOn() {
        return this.createdOn;
    }

    public ChatMessage setCreatedOn(OffsetDateTime createdOn) {
        this.createdOn = createdOn;
        return this;
    }

    public CommunicationIdentifier getSender() {
        return this.sender;
    }

    public ChatMessage setSender(CommunicationIdentifier sender) {
        this.sender = sender;
        return this;
    }

    public OffsetDateTime getDeletedOn() {
        return this.deletedOn;
    }

    public ChatMessage setDeletedOn(OffsetDateTime deletedOn) {
        this.deletedOn = deletedOn;
        return this;
    }

    public OffsetDateTime getEditedOn() {
        return this.editedOn;
    }

    public ChatMessage setEditedOn(OffsetDateTime editedOn) {
        this.editedOn = editedOn;
        return this;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public ChatMessage setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("type", this.type != null ? this.type.toString() : null);
        jsonWriter.writeJsonField("content", (JsonSerializable)this.content);
        jsonWriter.writeStringField("senderDisplayName", this.senderDisplayName);
        jsonWriter.writeStringField("createdOn", this.createdOn != null ? this.createdOn.toString() : null);
        jsonWriter.writeStringField("deletedOn", this.deletedOn != null ? this.deletedOn.toString() : null);
        jsonWriter.writeStringField("editedOn", this.editedOn != null ? this.editedOn.toString() : null);
        jsonWriter.writeMapField("metadata", this.metadata, JsonWriter::writeString);
        return jsonWriter.writeEndObject();
    }

    public static ChatMessage fromJson(JsonReader jsonReader) throws IOException {
        return (ChatMessage)jsonReader.readObject(reader -> {
            ChatMessage message = new ChatMessage();
            while (jsonReader.nextToken() != JsonToken.END_OBJECT) {
                String value;
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    message.setId(reader.getString());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    message.setType(ChatMessageType.fromString(reader.getString()));
                    continue;
                }
                if ("version".equals(fieldName)) {
                    message.setVersion(reader.getString());
                    continue;
                }
                if ("content".equals(fieldName)) {
                    message.setContent(ChatMessageContent.fromJson(reader));
                    continue;
                }
                if ("senderDisplayName".equals(fieldName)) {
                    message.setSenderDisplayName(reader.getString());
                    continue;
                }
                if ("createdOn".equals(fieldName)) {
                    value = reader.getString();
                    if (CoreUtils.isNullOrEmpty((CharSequence)value)) continue;
                    message.setCreatedOn(OffsetDateTime.parse(value));
                    continue;
                }
                if ("senderCommunicationIdentifier".equals(fieldName)) {
                    CommunicationIdentifierModel identifier = (CommunicationIdentifierModel)reader.readObject(CommunicationIdentifierModel::fromJson);
                    message.setSender(CommunicationIdentifierConverter.convert(identifier));
                    continue;
                }
                if ("deletedOn".equals(fieldName)) {
                    value = reader.getString();
                    if (CoreUtils.isNullOrEmpty((CharSequence)value)) continue;
                    message.setDeletedOn(OffsetDateTime.parse(value));
                    continue;
                }
                if ("editedOn".equals(fieldName)) {
                    value = reader.getString();
                    if (CoreUtils.isNullOrEmpty((CharSequence)value)) continue;
                    message.setEditedOn(OffsetDateTime.parse(value));
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    message.setMetadata(reader.readMap(JsonReader::getString));
                    continue;
                }
                reader.skipChildren();
            }
            return message;
        });
    }
}

