/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.chat.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class ChatError
implements JsonSerializable<ChatError> {
    private final String code;
    private final String message;
    private final String target;
    private final List<ChatError> details;
    private final ChatError innerError;

    public ChatError(String message, String code, String target, List<ChatError> details, ChatError innerError) {
        this.message = message;
        this.code = code;
        this.target = target;
        this.details = details;
        this.innerError = innerError;
    }

    public String getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public String getTarget() {
        return this.target;
    }

    public List<ChatError> getDetails() {
        return this.details;
    }

    public ChatError getInnerError() {
        return this.innerError;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("code", this.code);
        jsonWriter.writeStringField("message", this.message);
        jsonWriter.writeStringField("target", this.target);
        jsonWriter.writeArrayField("details", this.details, (writer, error) -> error.toJson((JsonWriter)writer));
        jsonWriter.writeJsonField("innerError", (JsonSerializable)this.innerError);
        return jsonWriter.writeEndObject();
    }

    public static ChatError fromJson(JsonReader jsonReader) throws IOException {
        return (ChatError)jsonReader.readObject(reader -> {
            String code = null;
            String message = null;
            String target = null;
            List details = null;
            ChatError innerError = null;
            while (jsonReader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("code".equals(fieldName)) {
                    code = reader.getString();
                    continue;
                }
                if ("message".equals(fieldName)) {
                    message = reader.getString();
                    continue;
                }
                if ("target".equals(fieldName)) {
                    target = reader.getString();
                    continue;
                }
                if ("details".equals(fieldName)) {
                    details = reader.readArray(ChatError::fromJson);
                    continue;
                }
                if ("innerError".equals(fieldName)) {
                    innerError = ChatError.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return new ChatError(message, code, target, details, innerError);
        });
    }
}

