/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.chat.implementation.models;

import com.azure.communication.chat.implementation.models.ChatParticipant;
import com.azure.communication.chat.implementation.models.ChatRetentionPolicy;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class CreateChatThreadOptions
implements JsonSerializable<CreateChatThreadOptions> {
    private String topic;
    private List<ChatParticipant> participants;
    private Map<String, String> metadata;
    private ChatRetentionPolicy retentionPolicy;

    public String getTopic() {
        return this.topic;
    }

    public CreateChatThreadOptions setTopic(String topic) {
        this.topic = topic;
        return this;
    }

    public List<ChatParticipant> getParticipants() {
        return this.participants;
    }

    public CreateChatThreadOptions setParticipants(List<ChatParticipant> participants) {
        this.participants = participants;
        return this;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public CreateChatThreadOptions setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public ChatRetentionPolicy getRetentionPolicy() {
        return this.retentionPolicy;
    }

    public CreateChatThreadOptions setRetentionPolicy(ChatRetentionPolicy retentionPolicy) {
        this.retentionPolicy = retentionPolicy;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("topic", this.topic);
        jsonWriter.writeArrayField("participants", this.participants, (writer, element) -> writer.writeJson((JsonSerializable)element));
        if (this.metadata != null) {
            jsonWriter.writeMapField("metadata", this.metadata, (writer, element) -> writer.writeString(element));
        }
        jsonWriter.writeJsonField("retentionPolicy", (JsonSerializable)this.retentionPolicy);
        return jsonWriter.writeEndObject();
    }

    public static CreateChatThreadOptions fromJson(JsonReader jsonReader) throws IOException {
        return (CreateChatThreadOptions)jsonReader.readObject(reader -> {
            CreateChatThreadOptions deserializedCreateChatThreadOptions = new CreateChatThreadOptions();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("topic".equals(fieldName)) {
                    deserializedCreateChatThreadOptions.topic = reader.getString();
                    continue;
                }
                if ("participants".equals(fieldName)) {
                    List participants;
                    deserializedCreateChatThreadOptions.participants = participants = reader.readArray(reader1 -> ChatParticipant.fromJson(reader1));
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    Map metadata;
                    deserializedCreateChatThreadOptions.metadata = metadata = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("retentionPolicy".equals(fieldName)) {
                    deserializedCreateChatThreadOptions.retentionPolicy = ChatRetentionPolicy.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCreateChatThreadOptions;
        });
    }
}

