/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.chat.implementation.models;

import com.azure.communication.chat.implementation.models.ChatRetentionPolicy;
import com.azure.communication.chat.implementation.models.CommunicationIdentifierModel;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;

public final class ChatThreadProperties
implements JsonSerializable<ChatThreadProperties> {
    private String id;
    private String topic;
    private OffsetDateTime createdOn;
    private CommunicationIdentifierModel createdByCommunicationIdentifier;
    private OffsetDateTime deletedOn;
    private Map<String, String> metadata;
    private ChatRetentionPolicy retentionPolicy;

    public String getId() {
        return this.id;
    }

    public ChatThreadProperties setId(String id) {
        this.id = id;
        return this;
    }

    public String getTopic() {
        return this.topic;
    }

    public ChatThreadProperties setTopic(String topic) {
        this.topic = topic;
        return this;
    }

    public OffsetDateTime getCreatedOn() {
        return this.createdOn;
    }

    public ChatThreadProperties setCreatedOn(OffsetDateTime createdOn) {
        this.createdOn = createdOn;
        return this;
    }

    public CommunicationIdentifierModel getCreatedByCommunicationIdentifier() {
        return this.createdByCommunicationIdentifier;
    }

    public ChatThreadProperties setCreatedByCommunicationIdentifier(CommunicationIdentifierModel createdByCommunicationIdentifier) {
        this.createdByCommunicationIdentifier = createdByCommunicationIdentifier;
        return this;
    }

    public OffsetDateTime getDeletedOn() {
        return this.deletedOn;
    }

    public ChatThreadProperties setDeletedOn(OffsetDateTime deletedOn) {
        this.deletedOn = deletedOn;
        return this;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public ChatThreadProperties setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public ChatRetentionPolicy getRetentionPolicy() {
        return this.retentionPolicy;
    }

    public ChatThreadProperties setRetentionPolicy(ChatRetentionPolicy retentionPolicy) {
        this.retentionPolicy = retentionPolicy;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("topic", this.topic);
        jsonWriter.writeStringField("createdOn", this.createdOn == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdOn));
        jsonWriter.writeJsonField("createdByCommunicationIdentifier", (JsonSerializable)this.createdByCommunicationIdentifier);
        jsonWriter.writeStringField("deletedOn", this.deletedOn == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.deletedOn));
        jsonWriter.writeMapField("metadata", this.metadata, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("retentionPolicy", (JsonSerializable)this.retentionPolicy);
        return jsonWriter.writeEndObject();
    }

    public static ChatThreadProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ChatThreadProperties)jsonReader.readObject(reader -> {
            ChatThreadProperties deserializedChatThreadProperties = new ChatThreadProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedChatThreadProperties.id = reader.getString();
                    continue;
                }
                if ("topic".equals(fieldName)) {
                    deserializedChatThreadProperties.topic = reader.getString();
                    continue;
                }
                if ("createdOn".equals(fieldName)) {
                    deserializedChatThreadProperties.createdOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("createdByCommunicationIdentifier".equals(fieldName)) {
                    deserializedChatThreadProperties.createdByCommunicationIdentifier = CommunicationIdentifierModel.fromJson(reader);
                    continue;
                }
                if ("deletedOn".equals(fieldName)) {
                    deserializedChatThreadProperties.deletedOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    Map metadata;
                    deserializedChatThreadProperties.metadata = metadata = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("retentionPolicy".equals(fieldName)) {
                    deserializedChatThreadProperties.retentionPolicy = ChatRetentionPolicy.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedChatThreadProperties;
        });
    }
}

