/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.chat.implementation.models;

import com.azure.communication.chat.implementation.models.CommunicationIdentifierModel;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;

public final class ChatParticipant
implements JsonSerializable<ChatParticipant> {
    private CommunicationIdentifierModel communicationIdentifier;
    private String displayName;
    private OffsetDateTime shareHistoryTime;
    private Map<String, String> metadata;

    public CommunicationIdentifierModel getCommunicationIdentifier() {
        return this.communicationIdentifier;
    }

    public ChatParticipant setCommunicationIdentifier(CommunicationIdentifierModel communicationIdentifier) {
        this.communicationIdentifier = communicationIdentifier;
        return this;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public ChatParticipant setDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public OffsetDateTime getShareHistoryTime() {
        return this.shareHistoryTime;
    }

    public ChatParticipant setShareHistoryTime(OffsetDateTime shareHistoryTime) {
        this.shareHistoryTime = shareHistoryTime;
        return this;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public ChatParticipant setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("communicationIdentifier", (JsonSerializable)this.communicationIdentifier);
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("shareHistoryTime", this.shareHistoryTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.shareHistoryTime));
        jsonWriter.writeMapField("metadata", this.metadata, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static ChatParticipant fromJson(JsonReader jsonReader) throws IOException {
        return (ChatParticipant)jsonReader.readObject(reader -> {
            ChatParticipant deserializedChatParticipant = new ChatParticipant();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("communicationIdentifier".equals(fieldName)) {
                    deserializedChatParticipant.communicationIdentifier = CommunicationIdentifierModel.fromJson(reader);
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    deserializedChatParticipant.displayName = reader.getString();
                    continue;
                }
                if ("shareHistoryTime".equals(fieldName)) {
                    deserializedChatParticipant.shareHistoryTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    Map metadata;
                    deserializedChatParticipant.metadata = metadata = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedChatParticipant;
        });
    }
}

