/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.chat.implementation.models;

import com.azure.communication.chat.implementation.models.CommunicationIdentifierModel;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class ChatMessageReadReceipt
implements JsonSerializable<ChatMessageReadReceipt> {
    private CommunicationIdentifierModel senderCommunicationIdentifier;
    private String chatMessageId;
    private OffsetDateTime readOn;

    public CommunicationIdentifierModel getSenderCommunicationIdentifier() {
        return this.senderCommunicationIdentifier;
    }

    public ChatMessageReadReceipt setSenderCommunicationIdentifier(CommunicationIdentifierModel senderCommunicationIdentifier) {
        this.senderCommunicationIdentifier = senderCommunicationIdentifier;
        return this;
    }

    public String getChatMessageId() {
        return this.chatMessageId;
    }

    public ChatMessageReadReceipt setChatMessageId(String chatMessageId) {
        this.chatMessageId = chatMessageId;
        return this;
    }

    public OffsetDateTime getReadOn() {
        return this.readOn;
    }

    public ChatMessageReadReceipt setReadOn(OffsetDateTime readOn) {
        this.readOn = readOn;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("senderCommunicationIdentifier", (JsonSerializable)this.senderCommunicationIdentifier);
        jsonWriter.writeStringField("chatMessageId", this.chatMessageId);
        jsonWriter.writeStringField("readOn", this.readOn == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.readOn));
        return jsonWriter.writeEndObject();
    }

    public static ChatMessageReadReceipt fromJson(JsonReader jsonReader) throws IOException {
        return (ChatMessageReadReceipt)jsonReader.readObject(reader -> {
            ChatMessageReadReceipt deserializedChatMessageReadReceipt = new ChatMessageReadReceipt();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("senderCommunicationIdentifier".equals(fieldName)) {
                    deserializedChatMessageReadReceipt.senderCommunicationIdentifier = CommunicationIdentifierModel.fromJson(reader);
                    continue;
                }
                if ("chatMessageId".equals(fieldName)) {
                    deserializedChatMessageReadReceipt.chatMessageId = reader.getString();
                    continue;
                }
                if ("readOn".equals(fieldName)) {
                    deserializedChatMessageReadReceipt.readOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedChatMessageReadReceipt;
        });
    }
}

