/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.chat.implementation.models;

import com.azure.communication.chat.implementation.models.ChatMessageContent;
import com.azure.communication.chat.implementation.models.CommunicationIdentifierModel;
import com.azure.communication.chat.models.ChatMessageType;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;

public final class ChatMessage
implements JsonSerializable<ChatMessage> {
    private String id;
    private ChatMessageType type;
    private String sequenceId;
    private String version;
    private ChatMessageContent content;
    private String senderDisplayName;
    private OffsetDateTime createdOn;
    private CommunicationIdentifierModel senderCommunicationIdentifier;
    private OffsetDateTime deletedOn;
    private OffsetDateTime editedOn;
    private Map<String, String> metadata;

    public String getId() {
        return this.id;
    }

    public ChatMessage setId(String id) {
        this.id = id;
        return this;
    }

    public ChatMessageType getType() {
        return this.type;
    }

    public ChatMessage setType(ChatMessageType type) {
        this.type = type;
        return this;
    }

    public String getSequenceId() {
        return this.sequenceId;
    }

    public ChatMessage setSequenceId(String sequenceId) {
        this.sequenceId = sequenceId;
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public ChatMessage setVersion(String version) {
        this.version = version;
        return this;
    }

    public ChatMessageContent getContent() {
        return this.content;
    }

    public ChatMessage setContent(ChatMessageContent content) {
        this.content = content;
        return this;
    }

    public String getSenderDisplayName() {
        return this.senderDisplayName;
    }

    public ChatMessage setSenderDisplayName(String senderDisplayName) {
        this.senderDisplayName = senderDisplayName;
        return this;
    }

    public OffsetDateTime getCreatedOn() {
        return this.createdOn;
    }

    public ChatMessage setCreatedOn(OffsetDateTime createdOn) {
        this.createdOn = createdOn;
        return this;
    }

    public CommunicationIdentifierModel getSenderCommunicationIdentifier() {
        return this.senderCommunicationIdentifier;
    }

    public ChatMessage setSenderCommunicationIdentifier(CommunicationIdentifierModel senderCommunicationIdentifier) {
        this.senderCommunicationIdentifier = senderCommunicationIdentifier;
        return this;
    }

    public OffsetDateTime getDeletedOn() {
        return this.deletedOn;
    }

    public ChatMessage setDeletedOn(OffsetDateTime deletedOn) {
        this.deletedOn = deletedOn;
        return this;
    }

    public OffsetDateTime getEditedOn() {
        return this.editedOn;
    }

    public ChatMessage setEditedOn(OffsetDateTime editedOn) {
        this.editedOn = editedOn;
        return this;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public ChatMessage setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("sequenceId", this.sequenceId);
        jsonWriter.writeStringField("version", this.version);
        jsonWriter.writeStringField("createdOn", this.createdOn == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdOn));
        jsonWriter.writeJsonField("content", (JsonSerializable)this.content);
        jsonWriter.writeStringField("senderDisplayName", this.senderDisplayName);
        jsonWriter.writeJsonField("senderCommunicationIdentifier", (JsonSerializable)this.senderCommunicationIdentifier);
        jsonWriter.writeStringField("deletedOn", this.deletedOn == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.deletedOn));
        jsonWriter.writeStringField("editedOn", this.editedOn == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.editedOn));
        jsonWriter.writeMapField("metadata", this.metadata, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static ChatMessage fromJson(JsonReader jsonReader) throws IOException {
        return (ChatMessage)jsonReader.readObject(reader -> {
            ChatMessage deserializedChatMessage = new ChatMessage();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedChatMessage.id = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedChatMessage.type = ChatMessageType.fromString(reader.getString());
                    continue;
                }
                if ("sequenceId".equals(fieldName)) {
                    deserializedChatMessage.sequenceId = reader.getString();
                    continue;
                }
                if ("version".equals(fieldName)) {
                    deserializedChatMessage.version = reader.getString();
                    continue;
                }
                if ("createdOn".equals(fieldName)) {
                    deserializedChatMessage.createdOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("content".equals(fieldName)) {
                    deserializedChatMessage.content = ChatMessageContent.fromJson(reader);
                    continue;
                }
                if ("senderDisplayName".equals(fieldName)) {
                    deserializedChatMessage.senderDisplayName = reader.getString();
                    continue;
                }
                if ("senderCommunicationIdentifier".equals(fieldName)) {
                    deserializedChatMessage.senderCommunicationIdentifier = CommunicationIdentifierModel.fromJson(reader);
                    continue;
                }
                if ("deletedOn".equals(fieldName)) {
                    deserializedChatMessage.deletedOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("editedOn".equals(fieldName)) {
                    deserializedChatMessage.editedOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    Map metadata;
                    deserializedChatMessage.metadata = metadata = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedChatMessage;
        });
    }
}

