/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.chat.implementation.models;

import com.azure.communication.chat.implementation.models.ChatAttachmentType;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ChatAttachment
implements JsonSerializable<ChatAttachment> {
    private String id;
    private ChatAttachmentType attachmentType;
    private String name;
    private String url;
    private String previewUrl;

    public String getId() {
        return this.id;
    }

    public ChatAttachment setId(String id) {
        this.id = id;
        return this;
    }

    public ChatAttachmentType getAttachmentType() {
        return this.attachmentType;
    }

    public ChatAttachment setAttachmentType(ChatAttachmentType attachmentType) {
        this.attachmentType = attachmentType;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public ChatAttachment setName(String name) {
        this.name = name;
        return this;
    }

    public String getUrl() {
        return this.url;
    }

    public ChatAttachment setUrl(String url) {
        this.url = url;
        return this;
    }

    public String getPreviewUrl() {
        return this.previewUrl;
    }

    public ChatAttachment setPreviewUrl(String previewUrl) {
        this.previewUrl = previewUrl;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("attachmentType", this.attachmentType == null ? null : this.attachmentType.toString());
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("url", this.url);
        jsonWriter.writeStringField("previewUrl", this.previewUrl);
        return jsonWriter.writeEndObject();
    }

    public static ChatAttachment fromJson(JsonReader jsonReader) throws IOException {
        return (ChatAttachment)jsonReader.readObject(reader -> {
            ChatAttachment deserializedChatAttachment = new ChatAttachment();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedChatAttachment.id = reader.getString();
                    continue;
                }
                if ("attachmentType".equals(fieldName)) {
                    deserializedChatAttachment.attachmentType = ChatAttachmentType.fromString(reader.getString());
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedChatAttachment.name = reader.getString();
                    continue;
                }
                if ("url".equals(fieldName)) {
                    deserializedChatAttachment.url = reader.getString();
                    continue;
                }
                if ("previewUrl".equals(fieldName)) {
                    deserializedChatAttachment.previewUrl = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedChatAttachment;
        });
    }
}

