/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.chat.implementation.converters;

import com.azure.communication.chat.implementation.converters.ChatRetentionPolicyConverter;
import com.azure.communication.chat.implementation.converters.CommunicationIdentifierConverter;
import com.azure.communication.chat.implementation.models.ChatRetentionPolicy;
import com.azure.communication.chat.models.ChatThreadProperties;
import java.util.Map;

public final class ChatThreadPropertiesConverter {
    public static ChatThreadProperties convert(com.azure.communication.chat.implementation.models.ChatThreadProperties obj) {
        ChatRetentionPolicy implPolicy;
        Map<String, String> metadata;
        if (obj == null) {
            return null;
        }
        ChatThreadProperties chatThreadProperties = new ChatThreadProperties().setId(obj.getId()).setTopic(obj.getTopic()).setCreatedOn(obj.getCreatedOn());
        if (obj.getCreatedByCommunicationIdentifier() != null) {
            chatThreadProperties.setCreatedBy(CommunicationIdentifierConverter.convert(obj.getCreatedByCommunicationIdentifier()));
        }
        if ((metadata = obj.getMetadata()) != null) {
            chatThreadProperties.setMetadata(metadata);
        }
        if ((implPolicy = obj.getRetentionPolicy()) != null) {
            chatThreadProperties.setRetentionPolicy(ChatRetentionPolicyConverter.convertFromImpl(implPolicy));
        }
        return chatThreadProperties;
    }

    private ChatThreadPropertiesConverter() {
    }
}

